/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.messages.IdentifiableMessage;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientServerProviderImpl
implements ClangClientServerProvider {
    private static final Logger LOG = Logger.getInstance((String)ClangClientServerProviderImpl.class.getName());

    @Override
    @Nullable
    public ClangClientServerProvider.ClientServerEndpoints bind(@NotNull ClangDaemonContext context2, final @NotNull ServerConnection connection, @NotNull Consumer<String> errorsHandler, @NotNull Consumer<String> outgoingLogger, @NotNull Consumer<String> incomingLogger) {
        ProxyExecutorService ioService = new ProxyExecutorService(context2.getDescriptor(), Executors.newCachedThreadPool());
        InputStream errorStream = connection.getErrorStream();
        if (errorStream != null) {
            ioService.execute(new ConnectionErrorsLogger(errorStream, errorsHandler));
        }
        InputStream inputStream = connection.getInputStream();
        OutputStream outputStream = connection.getOutputStream();
        if (inputStream == null || outputStream == null) {
            assert (!connection.isActive());
            ioService.shutdown();
            return null;
        }
        ClangCrashHandler guard = context2.getCrashHandler();
        ClangClient client = guard.spyOn(new ClangClientImpl(context2));
        ProxyMessageConsumer outgoing = new ProxyMessageConsumer();
        outgoing.addConsumer(message -> outgoingLogger.accept(message.toString()));
        ProxyMessageConsumer incoming = new ProxyMessageConsumer();
        incoming.addConsumer(message -> incomingLogger.accept(message.toString()));
        Launcher launcher = Launcher.createLauncher((Object)client, ClangServer.class, (InputStream)inputStream, (OutputStream)outputStream, (ExecutorService)ioService, (Function)new ConsumersProvider(outgoing, incoming));
        ClangServer server = (ClangServer)launcher.getRemoteProxy();
        RemoteEndpoint remoteEndpoint = launcher.getRemoteEndpoint();
        server = (ClangServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ClangServer.class}, (InvocationHandler)new ClangServerProtector(server));
        server = guard.spyOn(new ClangServerEx(server, remoteEndpoint, outgoing));
        java.util.logging.Logger lsp4jLogger = java.util.logging.Logger.getLogger(StreamMessageProducer.class.getName());
        Handler myKillHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel() == Level.SEVERE) {
                    connection.stop();
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        lsp4jLogger.addHandler(myKillHandler);
        try {
            Disposer.register((Disposable)context2, () -> lsp4jLogger.removeHandler(myKillHandler));
        }
        catch (IncorrectOperationException ex) {
            LOG.info((Throwable)ex);
            ioService.shutdown();
            return null;
        }
        launcher.startListening();
        return new DefaultClientServerEndpoints(ioService, server, client);
    }

    private static class ClangServerEx
    extends ClangServerAdapter {
        @NotNull
        private final RemoteEndpoint myRemoteEndpoint;
        @NotNull
        private final CopyOnWriteArrayList<Consumer<String>> myRequestIdsConsumers = new CopyOnWriteArrayList();

        ClangServerEx(@NotNull ClangServer myServer, @NotNull RemoteEndpoint remoteEndpoint, @NotNull ProxyMessageConsumer outgoing) {
            super(myServer);
            this.myRemoteEndpoint = remoteEndpoint;
            outgoing.addConsumer(message -> {
                if (message instanceof IdentifiableMessage) {
                    String id = ((IdentifiableMessage)message).getId();
                    for (Consumer<String> consumer : this.myRequestIdsConsumers) {
                        consumer.accept(id);
                    }
                }
            });
        }

        @Override
        @NotNull
        public Endpoint getRemoteEndpoint() {
            return this.myRemoteEndpoint;
        }

        @Override
        public void attachRequestsListener(@NotNull Consumer<String> idConsumer) {
            this.myRequestIdsConsumers.add(idConsumer);
        }

        @Override
        public void detachRequestsListener(@NotNull Consumer<String> idConsumer) {
            this.myRequestIdsConsumers.remove(idConsumer);
        }
    }

    private static class ClangServerProtector
    implements InvocationHandler {
        @NotNull
        private final ClangServer myServer;

        private ClangServerProtector(@NotNull ClangServer server) {
            this.myServer = server;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method m = ClangServerProtector.findMethod(this.myServer.getClass(), method);
            assert (m != null);
            if (ClangServerProtector.isProtectionOn(m)) {
                assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "I/O operation under write lock?";
                assert (!ApplicationManager.getApplication().isReadAccessAllowed()) : "I/O operation under read lock?";
            }
            return m.invoke((Object)this.myServer, args);
        }

        @Nullable
        private static Method findMethod(Class<?> clazz, Method method) {
            try {
                return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private static boolean isProtectionOn(@NotNull Method m) {
            return !m.getName().equals("shutdown") && !m.getName().equals("exit");
        }
    }

    private static class ProxyMessageConsumer
    implements MessageConsumer {
        @NotNull
        private final List<MessageConsumer> myDelegates = new ArrayList<MessageConsumer>();

        private ProxyMessageConsumer() {
        }

        public void addConsumer(@NotNull MessageConsumer consumer) {
            this.myDelegates.add(consumer);
        }

        public void consume(Message message) {
            for (MessageConsumer consumer : this.myDelegates) {
                consumer.consume(message);
            }
        }
    }

    private static class ConsumersProvider
    implements Function<MessageConsumer, MessageConsumer> {
        private final Stack<ProxyMessageConsumer> myConsumers = new Stack();

        ConsumersProvider(@NotNull ProxyMessageConsumer outgoing, @NotNull ProxyMessageConsumer incoming) {
            this.myConsumers.push((Object)incoming);
            this.myConsumers.push((Object)outgoing);
        }

        @Override
        public MessageConsumer apply(MessageConsumer consumer) {
            ProxyMessageConsumer proxy = (ProxyMessageConsumer)this.myConsumers.pop();
            proxy.addConsumer(consumer);
            return proxy;
        }
    }

    private static class ConnectionErrorsLogger
    implements Runnable {
        @NotNull
        private final BufferedReader myErrorsReader;
        @NotNull
        private final Consumer<String> myErrorsHandler;

        ConnectionErrorsLogger(@NotNull InputStream errorStream, @NotNull Consumer<String> errorsHandler) {
            this.myErrorsReader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));
            this.myErrorsHandler = errorsHandler;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.myErrorsReader.readLine()) != null) {
                    this.myErrorsHandler.accept(line);
                }
            }
            catch (InterruptedIOException line) {
            }
            catch (ClosedChannelException line) {
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
            }
            catch (Throwable thr) {
                LOG.error(thr);
            }
        }
    }

    private static class DefaultClientServerEndpoints
    implements ClangClientServerProvider.ClientServerEndpoints {
        @NotNull
        private final ExecutorService myIoService;
        @NotNull
        private final ClangServer myServer;
        @NotNull
        private final ClangClient myClient;

        DefaultClientServerEndpoints(@NotNull ExecutorService ioService, @NotNull ClangServer server, @NotNull ClangClient client) {
            this.myIoService = ioService;
            this.myServer = server;
            this.myClient = client;
        }

        @Override
        @NotNull
        public ClangServer getServer() {
            return this.myServer;
        }

        @Override
        @NotNull
        public ClangClient getClient() {
            return this.myClient;
        }

        public void dispose() {
            this.myIoService.shutdown();
        }
    }

    private static final class ProxyExecutorService
    implements ExecutorService {
        private boolean hadFirstSubmission;
        private boolean hadSecondSubmission;
        @NotNull
        private String myDescriptor;
        @NotNull
        private final ExecutorService myDelegate;

        private ProxyExecutorService(@NotNull String descriptor, @NotNull ExecutorService delegate) {
            this.myDescriptor = descriptor;
            this.myDelegate = delegate;
        }

        @Override
        public void shutdown() {
            this.myDelegate.shutdown();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return this.myDelegate.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.myDelegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.myDelegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            return this.myDelegate.awaitTermination(timeout, unit);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task2) {
            return this.myDelegate.submit(task2);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task2, T result2) {
            return this.myDelegate.submit(this.wrapRunnable(task2), result2);
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task2) {
            return this.myDelegate.submit(this.wrapRunnable(task2));
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks2) throws InterruptedException {
            return this.myDelegate.invokeAll(tasks2);
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks2, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            return this.myDelegate.invokeAll(tasks2, timeout, unit);
        }

        @Override
        @NotNull
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks2) throws InterruptedException, ExecutionException {
            return this.myDelegate.invokeAny(tasks2);
        }

        @Override
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks2, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.myDelegate.invokeAny(tasks2, timeout, unit);
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.myDelegate.execute(this.wrapRunnable(command));
        }

        @NotNull
        private Runnable wrapRunnable(@NotNull Runnable runnable) {
            return ConcurrencyUtil.underThreadNameRunnable((String)this.getThreadName(), () -> {
                try {
                    runnable.run();
                }
                catch (JsonRpcException ex) {
                    if (!(ex.getCause() instanceof IOException) || !StringUtil.notNullize((String)ex.getCause().getMessage()).contains("Stream closed:")) {
                        LOG.error((Throwable)ex);
                        throw ex;
                    }
                }
                catch (Throwable ex) {
                    LOG.error(ex);
                    throw ex;
                }
            });
        }

        @NotNull
        private String getThreadName() {
            if (!this.hadFirstSubmission) {
                this.hadFirstSubmission = true;
                return "Clangd errors reader [" + this.myDescriptor + "]";
            }
            if (!this.hadSecondSubmission) {
                this.hadSecondSubmission = true;
                return "Clangd output reader [" + this.myDescriptor + "]";
            }
            LOG.error("Unexpected I/O task!");
            return "Clangd reader";
        }
    }
}

