/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.util.ClassConditionKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.jetbrains.annotations.NotNull;

public class ClangdLookupElement<T extends LookupElement>
extends LookupElementDecorator<T> {
    public static final ClassConditionKey<ClangdLookupElement> CLASS_CONDITION_KEY = ClassConditionKey.create(ClangdLookupElement.class);
    private final CLionCompletionItem myItem;
    private final double myScore;
    private final CompletionItemKind myKind;

    protected ClangdLookupElement(T delegate, CLionCompletionItem item) {
        super(delegate);
        this.myItem = item;
        this.myScore = Double.parseDouble(item.getSortText());
        this.myKind = item.getKind();
    }

    public double getScore() {
        return this.myScore;
    }

    public CompletionItemKind getKind() {
        return this.myKind;
    }

    public boolean requiresCommittedDocuments() {
        return false;
    }

    public static LookupElement withCompletionItem(@NotNull LookupElement element, @NotNull CLionCompletionItem item) {
        ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(CLASS_CONDITION_KEY));
        LookupElement finalElement = clangdElement == null ? element : clangdElement.getDelegate();
        return new ClangdLookupElement<LookupElement>(finalElement, item);
    }

    @NotNull
    public CLionCompletionItem getCompletionItem() {
        return this.myItem;
    }
}

