/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdCodeCompletionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdFeatureProvider$WhenMappings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdLookupElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.CompletionItemKind;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J)\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/completion/ClangdFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "symbolKindFromClangdCompletionItem", "Lcom/jetbrains/cidr/lang/symbols/OCSymbolKind;", "clangdCompletionItem", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/completion/CLionCompletionItem;", "symbolKindFromLookup", "from_clangd", "", "from_idea", "(Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/jetbrains/cidr/lang/symbols/OCSymbolKind;", "intellij.c"})
public final class ClangdFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "clangd";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Integer from_clangd = (Integer)element.getUserData(ClangdCodeCompletionProvider.CLANGD_TIMESTAMP);
        Integer from_idea = (Integer)element.getUserData(ClangdCodeCompletionProvider.IDEA_TIMESTAMP);
        if (from_clangd == null && from_idea == null) {
            return MapsKt.emptyMap();
        }
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        if (from_clangd != null) {
            result2.put("clangd", MLFeatureValue.Companion.float(from_clangd.intValue()));
        }
        if (from_idea != null) {
            result2.put("idea", MLFeatureValue.Companion.float(from_idea.intValue()));
        }
        result2.put("kind", MLFeatureValue.Companion.categorical((Enum)this.symbolKindFromLookup(element, from_clangd, from_idea)));
        if (element instanceof ClangdLookupElement) {
            result2.put("clangdScore", MLFeatureValue.Companion.float(((ClangdLookupElement)element).getScore()));
        }
        return result2;
    }

    private final OCSymbolKind symbolKindFromClangdCompletionItem(CLionCompletionItem clangdCompletionItem) {
        CompletionItemKind completionItemKind = clangdCompletionItem.getKind();
        if (completionItemKind != null) {
            switch (ClangdFeatureProvider$WhenMappings.$EnumSwitchMapping$0[completionItemKind.ordinal()]) {
                case 1: {
                    return CLionCompletionFlags.isTemplateArg(clangdCompletionItem.getCLionFlags()) ? OCSymbolKind.TEMPLATE_TYPE_PARAMETER : OCSymbolKind.MACRO;
                }
                case 2: {
                    return OCSymbolKind.METHOD;
                }
                case 3: {
                    return OCSymbolKind.FUNCTION_DECLARATION;
                }
                case 4: {
                    return OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION;
                }
                case 5: {
                    return OCSymbolKind.STRUCT_FIELD;
                }
                case 6: {
                    return CLionCompletionFlags.isLocal(clangdCompletionItem.getCLionFlags()) ? OCSymbolKind.LOCAL_VARIABLE : OCSymbolKind.GLOBAL_VARIABLE;
                }
                case 7: {
                    return OCSymbolKind.STRUCT;
                }
                case 8: 
                case 9: {
                    return OCSymbolKind.TYPEDEF;
                }
                case 10: {
                    return OCSymbolKind.NAMESPACE;
                }
                case 11: {
                    return OCSymbolKind.PARAMETER;
                }
                case 12: {
                    return OCSymbolKind.ENUM_CONST;
                }
                case 13: {
                    return OCSymbolKind.ENUM;
                }
                case 14: 
                case 15: {
                    return OCSymbolKind.KEYWORD;
                }
                case 16: {
                    return OCSymbolKind.FILE;
                }
                case 17: {
                    return OCSymbolKind.FOLDER;
                }
            }
        }
        return OCSymbolKind.UNKNOWN;
    }

    private final OCSymbolKind symbolKindFromLookup(LookupElement element, Integer from_clangd, Integer from_idea) {
        if (from_idea != null) {
            PsiElement psi = CompletionUtil.getTargetElement((LookupElement)element);
            if (psi != null) {
                if (psi instanceof OCFile) {
                    return OCSymbolKind.FILE;
                }
                if (psi instanceof PsiDirectory) {
                    return OCSymbolKind.FOLDER;
                }
                if (!(psi instanceof OCSymbolDeclarator)) {
                    psi = psi.getParent();
                }
                if (psi instanceof OCSymbolDeclarator) {
                    Object t = ((OCSymbolDeclarator)psi).getSymbol();
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    return t.getKind();
                }
            } else {
                return OCSymbolKind.KEYWORD;
            }
        }
        if (from_clangd != null) {
            if (element instanceof PrioritizedLookupElement) {
                Object lookupBuilderObject;
                LookupElement delegate = ((PrioritizedLookupElement)element).getDelegate();
                if (delegate instanceof LookupElementBuilder && (lookupBuilderObject = delegate.getObject()) instanceof CLionCompletionItem) {
                    return this.symbolKindFromClangdCompletionItem((CLionCompletionItem)((Object)lookupBuilderObject));
                }
            } else if (element instanceof ClangdLookupElement) {
                return this.symbolKindFromClangdCompletionItem(((ClangdLookupElement)element).getCompletionItem());
            }
        }
        return OCSymbolKind.UNKNOWN;
    }
}

