/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

public enum CLionCompletionFlags {
    CLion_None(0),
    CLion_AS_public(1),
    CLion_AS_protected(2),
    CLion_AS_private(4),
    CLion_SC_Extern(8),
    CLion_SC_Static(16),
    CLion_SC_PrivateExtern(32),
    CLion_SC_Auto(64),
    CLion_SC_Register(128),
    CLion_NotAvailable(256),
    CLion_NotAccessible(512),
    CLion_Constant(1024),
    CLion_VirtualMethod(2048),
    CLion_Directive(4096),
    CLion_Macro(8192),
    CLion_TemplateArg(16384),
    CLion_Class(32768),
    CLion_Struct(65536),
    CLion_Union(131072),
    CLion_Deprecated(262144),
    CLion_Local(524288),
    CLion_Framework(0x100000),
    CLion_InsertPlaceholders(0x200000),
    CLion_OverrideCall(0x400000);

    private final int value;

    private CLionCompletionFlags(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static boolean isPublic(int value) {
        return (value & CLion_AS_public.getValue()) != 0;
    }

    public static boolean isProtected(int value) {
        return (value & CLion_AS_protected.getValue()) != 0;
    }

    public static boolean isPrivate(int value) {
        return (value & CLion_AS_private.getValue()) != 0;
    }

    public static boolean isExtern(int value) {
        return (value & CLion_SC_Extern.getValue()) != 0;
    }

    public static boolean isStatic(int value) {
        return (value & CLion_SC_Static.getValue()) != 0;
    }

    public static boolean isPrivateExtern(int value) {
        return (value & CLion_SC_PrivateExtern.getValue()) != 0;
    }

    public static boolean isNotAvailable(int value) {
        return (value & CLion_NotAvailable.getValue()) != 0;
    }

    public static boolean isNotAccessible(int value) {
        return (value & CLion_NotAccessible.getValue()) != 0;
    }

    public static boolean isConstant(int value) {
        return (value & CLion_Constant.getValue()) != 0;
    }

    public static boolean isVirtualMethod(int value) {
        return (value & CLion_VirtualMethod.getValue()) != 0;
    }

    public static boolean isDirective(int value) {
        return (value & CLion_Directive.getValue()) != 0;
    }

    public static boolean isMacro(int value) {
        return (value & CLion_Macro.getValue()) != 0;
    }

    public static boolean isTemplateArg(int value) {
        return (value & CLion_TemplateArg.getValue()) != 0;
    }

    public static boolean isClass(int value) {
        return (value & CLion_Class.getValue()) != 0;
    }

    public static boolean isStruct(int value) {
        return (value & CLion_Struct.getValue()) != 0;
    }

    public static boolean isUnion(int value) {
        return (value & CLion_Union.getValue()) != 0;
    }

    public static boolean isDeprecated(int value) {
        return (value & CLion_Deprecated.getValue()) != 0;
    }

    public static boolean isLocal(int value) {
        return (value & CLion_Local.getValue()) != 0;
    }

    public static boolean isFramework(int value) {
        return (value & CLion_Framework.getValue()) != 0;
    }

    public static boolean needInsertPlaceholders(int value) {
        return (value & CLion_InsertPlaceholders.getValue()) != 0;
    }

    public static boolean isOverrideCall(int value) {
        return (value & CLion_OverrideCall.getValue()) != 0;
    }
}

