/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DisableClangWarningIntentionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangWarningProblemGroup
implements SuppressableProblemGroup,
ClangProblemGroup {
    public static final String PROBLEM_NAME = "Clang warnings";
    @NotNull
    private final String myDiagID;
    private final SuppressIntentionAction @NotNull [] mySuppressIntentionActions;

    public ClangWarningProblemGroup(@NotNull PsiFile psiFile, @NotNull TextRange range, @NotNull String warningName) {
        HighlightDisplayKey.findOrRegister((String)PROBLEM_NAME, (String)PROBLEM_NAME, (String)PROBLEM_NAME);
        this.myDiagID = warningName;
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("clang", warningName);
        OCFile ocFile = OCLanguageUtils.asOCFile(psiFile);
        this.mySuppressIntentionActions = new SuppressIntentionAction[]{new DisableClangWarningIntentionAction(warningName), new OCSuppressClangForFile(ocFile, range, suppressionGroup), new OCSuppressClangForCallable(ocFile, range, suppressionGroup), new OCSuppressClangForStatement(ocFile, range, suppressionGroup)};
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(@Nullable PsiElement element) {
        return this.mySuppressIntentionActions;
    }

    @Nullable
    public String getProblemName() {
        return PROBLEM_NAME;
    }

    @Override
    @Nullable
    public String getDiagnosticID() {
        return this.myDiagID;
    }
}

