/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorSlowPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myRestrictRange;
    private final int myClangErrorsPassId;
    @Nullable
    private List<HighlightInfo> updatedHighlights;

    public ClangErrorsAnnotatorSlowPass(@NotNull PsiFile file2, @NotNull Document document2, @NotNull TextRange restrictRange, int clangErrorsPassId) {
        super(file2.getProject(), document2);
        this.myFile = file2;
        this.myRestrictRange = restrictRange;
        this.myClangErrorsPassId = clangErrorsPassId;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (!ClangUtils.isClangdOn(this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtilsKt.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        Map clangDiagnosticsMap = (Map)this.myFile.getUserData(ClangAppliedDiagnostic.CLANGD_ANNOTATIONS);
        if (ContainerUtil.isEmpty((Map)clangDiagnosticsMap)) {
            return;
        }
        this.updatedHighlights = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)this.myRestrictRange.getStartOffset(), (int)this.myRestrictRange.getEndOffset(), highlightInfo -> {
            if (highlightInfo.getProblemGroup() instanceof ClangProblemGroup) {
                this.updatedHighlights.add((HighlightInfo)highlightInfo);
            }
            return true;
        });
        for (int i2 = 0; i2 < this.updatedHighlights.size(); ++i2) {
            PsiElement psiContext;
            ClangHighlightKey highlightKey;
            ClangAppliedDiagnostic appliedDiag;
            HighlightInfo highlight = this.updatedHighlights.get(i2);
            if (!this.myRestrictRange.contains(highlight.getStartOffset()) || !this.myRestrictRange.containsOffset(highlight.getEndOffset()) || (appliedDiag = (ClangAppliedDiagnostic)clangDiagnosticsMap.get(highlightKey = new ClangHighlightKey(highlight))) == null || (psiContext = this.myFile.findElementAt(highlight.getStartOffset())) == null) continue;
            OCResolveContext context2 = OCResolveContext.forPsi(psiContext);
            HighlightInfo clonedHighlight = ClangErrorsAnnotatorPass.mergeHighlights(appliedDiag.annotation, appliedDiag.annotation, this.myDocument, this.getColorsScheme());
            assert (clonedHighlight.getProblemGroup() instanceof ClangProblemGroup);
            for (ClionFixItHint fixit : appliedDiag.diagnostic.getClionFixits()) {
                for (IntentionAction quickFix : ClangQuickFixFactoryKt.getClangQuickFixes(fixit, context2, psiContext)) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)clonedHighlight, (IntentionAction)quickFix);
                }
            }
            this.updatedHighlights.set(i2, clonedHighlight);
        }
    }

    public void doApplyInformationToEditor() {
        if (this.updatedHighlights == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)this.myRestrictRange.getStartOffset(), (int)this.myRestrictRange.getEndOffset(), this.updatedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.myClangErrorsPassId);
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
    }
}

