/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangCrashReport {
    @NotNull
    private final List<CrashedFile> myCrashedFiles;

    public ClangCrashReport(@NotNull List<CrashedFile> crashedFiles) {
        this.myCrashedFiles = crashedFiles;
    }

    @NotNull
    public List<CrashedFile> getCrashedFiles() {
        return Collections.unmodifiableList(this.myCrashedFiles);
    }

    public static class CrashedFile {
        @NotNull
        public final String url;
        @NotNull
        public final List<String> commandLine;
        @NotNull
        public final String clangTidyConfig;
        @NotNull
        public final String clionClangTidyConfig;
        public final boolean namehintsEnabled;
        public final boolean dfaInputEnabled;
        @NotNull
        public final UnusedIncludesInspectionMode unusedIncludesMode;
        @NotNull
        public final String diags;
        @Nullable
        public final String content;

        public CrashedFile(@NotNull String url, @NotNull List<String> commandLine, @NotNull String clangTidyConfig, @NotNull String clionClangTidyConfig, boolean namehintsEnabled, boolean dfaInputEnabled, @NotNull UnusedIncludesInspectionMode unusedIncludesMode, @NotNull String diags, @Nullable String content) {
            this.url = url;
            this.commandLine = commandLine;
            this.clangTidyConfig = clangTidyConfig;
            this.clionClangTidyConfig = clionClangTidyConfig;
            this.namehintsEnabled = namehintsEnabled;
            this.dfaInputEnabled = dfaInputEnabled;
            this.unusedIncludesMode = unusedIncludesMode;
            this.diags = diags;
            this.content = content;
        }
    }
}

