/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAnnotator
extends OCVisitor
implements Annotator,
OCAnnotatorSink {
    public static final Key<Object> ALWAYS_ANNOTATE = Key.create((String)"ALWAYS_ANNOTATE");
    private static final String ERROR_AFTER_MACRO_SUBSTITUTION = "Error after macro substitution: ";
    public static final String CIDR_DIAG = "CIDR";
    @Nullable
    private AnnotationHolder myHolder;
    private PsiElement myAnnotatingElement;

    @NotNull
    public static List<OCAnnotatorHelper> getAnnotatorHelpers() {
        return OCAnnotatorHelper.EP_NAME.getExtensionList();
    }

    @Nullable
    public AnnotationHolder getHolder() {
        return this.myHolder;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        this.annotate(psiElement, holder, holder.getCurrentAnnotationSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @Nullable AnnotationHolder holder, @NotNull AnnotationSession session) {
        OCFile ocFile = OCLanguageUtils.asOCFile(session.getFile());
        if (ocFile == null || psiElement.getContainingFile() != ocFile) {
            return;
        }
        Project project2 = ocFile.getProject();
        if (!OCAnnotator.isAnnotated(project2, ocFile.getVirtualFile())) {
            return;
        }
        ocFile.pushAnnotationSession(session);
        this.myHolder = holder;
        this.myAnnotatingElement = psiElement;
        try {
            if (this.isEnabled(ocFile)) {
                this.myAnnotatingElement.accept((PsiElementVisitor)this);
            }
        }
        finally {
            this.myHolder = null;
            this.myAnnotatingElement = null;
            ocFile.popAnnotationSession();
        }
    }

    protected boolean isEnabled(@NotNull PsiFile file2) {
        return true;
    }

    public static boolean isAnnotated(@NotNull Project project2, @Nullable VirtualFile file2) {
        return OCAnnotator.doIsAnnotated(project2, file2, true);
    }

    public static boolean isAnnotatedAsUserCode(@NotNull Project project2, @Nullable VirtualFile file2) {
        return OCAnnotator.doIsAnnotated(project2, file2, false);
    }

    private static boolean doIsAnnotated(@NotNull Project project2, @Nullable VirtualFile file2, boolean includingLibraries) {
        if (file2 == null || !OCLanguageUtils.isSupported(file2)) {
            return false;
        }
        if (project2.getUserData(ALWAYS_ANNOTATE) != null) {
            return true;
        }
        return includingLibraries ? OCSearchScope.isInProjectSourcesOrLibraries(project2, file2) : OCSearchScope.isInProjectSources(project2, file2);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addErrorAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCElement context2 = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCallArgument.class, OCDirective.class});
        if (context2 != null) {
            if (context2 instanceof OCDirective) {
                PsiElement headerToken = ((OCDirective)context2).getHeaderToken();
                IElementType type = headerToken.getNode().getElementType();
                if (type != OCTokenTypes.ERROR_DIRECTIVE && type != OCTokenTypes.WARNING_DIRECTIVE) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (macroRange == null) {
            return this.addErrorAnnotation(range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addErrorAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (!message.startsWith(ERROR_AFTER_MACRO_SUBSTITUTION)) {
                message = ERROR_AFTER_MACRO_SUBSTITUTION + message;
            }
            return this.addErrorAnnotation(macroCall, macroCall.getTextRange(), inspectionClass, clangID, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(macroRange.getArgumentRange(), inspectionClass, clangID, message, highlightType);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (this.myHolder == null || range == null || range.isEmpty()) {
            return null;
        }
        OCFile file2 = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file2, range, clangID, inspectionClass);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file2, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case WARNING: {
                    highlightType = ProblemHighlightType.WEAK_WARNING;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        return annotation;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (element == null) {
            return null;
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange == null) {
            return this.doAddWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addWarningAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            if (OCElementUtil.getRangeInMacroCall(this.myAnnotatingElement) == null) {
                return this.doAddWarningAnnotation(macroRange.getMacroCall(), macroRange.getMacroCall().getTextRange(), inspectionClass, clangID, message, highlightType);
            }
            return null;
        }
        return this.doAddWarningAnnotation(element, macroRange.getTextRange(), inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation doAddWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (range == null || range.isEmpty()) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class) != null) {
            return null;
        }
        if (this.myHolder == null) {
            return null;
        }
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(inspectionClass, element, HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return null;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file2 = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file2, range, clangID, inspectionClass);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file2, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createAnnotation(highlightSeverity, range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        return annotation;
    }

    @Nullable
    public static OCProblemGroup getProblemGroup(@Nullable OCFile file2, @NotNull TextRange range, @Nullable String problemID, @NotNull Class<? extends OCInspection> inspectionClass) {
        OCClangMessageDescriptor descriptor;
        if (problemID == null) {
            return null;
        }
        String inspectionId = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionId == null) {
            return null;
        }
        OCSuppressionGroup suppressionGroup = problemID.startsWith(CIDR_DIAG) ? new OCSuppressionGroup("ide", problemID.equals(CIDR_DIAG) ? inspectionClass.getSimpleName() : problemID.substring(CIDR_DIAG.length())) : ((descriptor = OCClangMessageFinder.getInstance().getSupportedMessageDescriptor(problemID)) != null ? descriptor.getSuppressionGroup() : null);
        return new OCProblemGroup(inspectionId, suppressionGroup, file2, range);
    }

    private void setupAnnotation(@Nullable Annotation annotation, @Nullable ProblemHighlightType highlightType, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable OCProblemGroup problemGroup) {
        if (annotation != null) {
            this.registerQuickFix(annotation, (IntentionAction)new EmptyIntentionAction(OCCodeInsightUtil.getPrettyNameFromClassName(inspectionClass)));
            if (problemGroup != null) {
                annotation.setProblemGroup((ProblemGroup)problemGroup);
            }
            annotation.setHighlightType(highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @NotNull
    public static ProblemHighlightType getProblemHighlightType(@NotNull HighlightSeverity highlightSeverity, @NotNull ProblemHighlightType defaultHighlightType) {
        ProblemHighlightType highlightType = defaultHighlightType;
        if (!highlightSeverity.equals((Object)HighlightSeverity.WARNING)) {
            if (highlightSeverity.equals((Object)HighlightSeverity.ERROR)) {
                highlightType = ProblemHighlightType.ERROR;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.INFORMATION)) {
                highlightType = ProblemHighlightType.INFORMATION;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.WEAK_WARNING)) {
                highlightType = ProblemHighlightType.WEAK_WARNING;
            }
        }
        return highlightType;
    }

    @Override
    public void registerQuickFix(@Nullable Annotation annotation, @NotNull IntentionAction intentionAction) {
        if (annotation != null) {
            if (intentionAction instanceof SuppressIntentionAction) {
                OCProblemGroup problemGroup = (OCProblemGroup)annotation.getProblemGroup();
                if (problemGroup != null) {
                    problemGroup.addSuppressAction((SuppressIntentionAction)intentionAction);
                }
            } else {
                Annotation.QuickFixInfo emptyFix;
                List quickFixes2 = annotation.getQuickFixes();
                Annotation.QuickFixInfo quickFixInfo = emptyFix = quickFixes2 != null ? (Annotation.QuickFixInfo)ContainerUtil.find((Iterable)quickFixes2, info -> info.quickFix instanceof EmptyIntentionAction) : null;
                if (emptyFix != null) {
                    quickFixes2.remove(emptyFix);
                }
                annotation.registerFix(intentionAction);
                if (intentionAction instanceof OCQuickFix && ((OCQuickFix)intentionAction).isSupportedInBatchMode() && ((OCQuickFix)intentionAction).isAvailable()) {
                    annotation.registerBatchFix((IntentionAction)((OCQuickFix)intentionAction), null, null);
                }
            }
        }
    }

    @Override
    public boolean highlight(@Nullable PsiElement element, @Nullable TextAttributesKey key) {
        if (element != null && element.getTextLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(key).create();
            return true;
        }
        return false;
    }

    @Override
    public void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(key).create();
        }
    }
}

