/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.PlatformIcons;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import icons.CidrLangIcons;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCIcons {
    private static final Icon STATIC_MARK_ICON = AllIcons.Nodes.StaticMark;
    private static final Icon CONST_MARK_ICON = AllIcons.Nodes.FinalMark;
    private static final Icon NON_VIRTUAL_MARK_ICON = AllIcons.Nodes.FinalMark;
    private static final Icon TEST_MARK_ICON = AllIcons.RunConfigurations.TestMark;
    private static final Icon PUBLIC_MARK_ICON = PlatformIcons.PUBLIC_ICON;
    private static final Icon PACKAGE_MARK_ICON = PlatformIcons.PACKAGE_LOCAL_ICON;
    private static final Icon PROTECTED_MARK_ICON = PlatformIcons.PROTECTED_ICON;
    private static final Icon PRIVATE_MARK_ICON = PlatformIcons.PRIVATE_ICON;
    private static final Map<Pair<Icon, Icon>, Icon> ourPatchedIcons = new ConcurrentHashMap<Pair<Icon, Icon>, Icon>();

    private OCIcons() {
    }

    private static Icon load(String path) {
        return IconLoader.getIcon((String)path, OCIcons.class);
    }

    public static Icon getMethodIcon(boolean isStatic, boolean isOptional, boolean isAbstract) {
        Icon icon = isOptional ? CidrLangIcons.CodeAssistantMemberOptional : (isAbstract ? CidrLangIcons.CodeAssistantMemberAbstract : CidrLangIcons.CodeAssistantMember);
        return isStatic ? OCIcons.getStaticIcon(icon) : icon;
    }

    public static Icon getPropertyIcon(boolean isStatic, boolean isOptional) {
        Icon icon = isOptional ? CidrLangIcons.CodeAssistantPropertyOptional : CidrLangIcons.CodeAssistantProperty;
        return isStatic ? OCIcons.getStaticIcon(icon) : icon;
    }

    public static Icon getFunctionIcon(boolean isStatic, boolean isAbstract, boolean isNonVirtual, OCVisibility visibility) {
        Icon icon = isAbstract ? CidrLangIcons.CodeAssistantFunctionAbstract : CidrLangIcons.CodeAssistantFunction;
        icon = isStatic ? OCIcons.getStaticIcon(icon) : icon;
        icon = isNonVirtual ? OCIcons.addLayer(icon, NON_VIRTUAL_MARK_ICON, false) : icon;
        return OCIcons.getVisibilityIcon(visibility, icon);
    }

    @Nullable
    private static Icon addLayer(@Nullable Icon baseIcon, @NotNull Icon newLayer, boolean nextRow) {
        if (baseIcon == null) {
            return null;
        }
        Pair pair = Pair.create((Object)baseIcon, (Object)newLayer);
        Icon patchedIcon = ourPatchedIcons.get(pair);
        if (patchedIcon == null) {
            if (baseIcon instanceof LayeredIcon && !nextRow) {
                Icon[] layers = ((LayeredIcon)baseIcon).getAllLayers();
                LayeredIcon layeredIcon = new LayeredIcon(layers.length + 1);
                for (int i2 = 0; i2 < layers.length; ++i2) {
                    layeredIcon.setIcon(layers[i2], i2);
                }
                layeredIcon.setIcon(newLayer, layers.length);
                patchedIcon = layeredIcon;
            } else if (nextRow) {
                RowIcon rowIcon = IconManager.getInstance().createRowIcon(2);
                rowIcon.setIcon(baseIcon, 0);
                rowIcon.setIcon(newLayer, 1);
                patchedIcon = rowIcon;
            } else {
                patchedIcon = new LayeredIcon(new Icon[]{baseIcon, newLayer});
            }
            ourPatchedIcons.put((Pair<Icon, Icon>)pair, patchedIcon);
        }
        return patchedIcon;
    }

    public static Icon getStaticIcon(@Nullable Icon icon) {
        return OCIcons.addLayer(icon, STATIC_MARK_ICON, false);
    }

    public static Icon getConstIcon(@Nullable Icon icon) {
        return OCIcons.addLayer(icon, CONST_MARK_ICON, false);
    }

    public static Icon getVisibilityIcon(@Nullable OCVisibility visibility, Icon baseIcon) {
        if (visibility == null) {
            return baseIcon;
        }
        switch (visibility) {
            case PUBLIC: {
                return OCIcons.addLayer(baseIcon, PUBLIC_MARK_ICON, true);
            }
            case PACKAGE: {
                return OCIcons.addLayer(baseIcon, PACKAGE_MARK_ICON, true);
            }
            case PROTECTED: {
                return OCIcons.addLayer(baseIcon, PROTECTED_MARK_ICON, true);
            }
            case PRIVATE: {
                return OCIcons.addLayer(baseIcon, PRIVATE_MARK_ICON, true);
            }
        }
        return baseIcon;
    }

    @Nullable
    public static Icon getTestIcon(@Nullable Icon icon) {
        return OCIcons.addLayer(icon, TEST_MARK_ICON, false);
    }
}

