/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCTextFieldCompletionProvider;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestWithScopeElementsRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestRunConfigurationEditorWithLWValidation<String, BC, TARGET, CONFIGURATION, BCH> {
    private final Class<? extends CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement>> myFrameworkClass;

    public CidrTestWithScopeElementsRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper, @Nullable Class<? extends CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement>> frameworkClass) {
        super(project2, configHelper);
        this.myFrameworkClass = frameworkClass;
    }

    @Override
    protected boolean isChecking() {
        return OCTestFramework.getInstance(this.myFrameworkClass).getUpdater(this.myProject).isIndexing();
    }

    @NotNull
    protected Set<String> collectStringsFromProject(@NotNull Project project2, @Nullable Consumer<Pair<CidrTestScopeElement, Set<String>>> consumer) {
        return OCFieldAdapter.collectAllValues(project2, Collections.emptySet(), () -> {
            if (project2.isDisposed() || this.isDisposed()) {
                return Collections.emptySet();
            }
            TreeSet result2 = new TreeSet();
            this.consumeTestObjects(project2, (Processor<CidrTestScopeElement>)((Processor)testInfo -> {
                if (consumer != null) {
                    consumer.accept(Pair.create((Object)testInfo, (Object)result2));
                }
                return true;
            }));
            return result2;
        });
    }

    protected void consumeTestObjects(@NotNull Project project2, Processor<? super CidrTestScopeElement> processor2) {
        OCTestFramework.getInstance(this.myFrameworkClass).consumeTestObjects(project2, null, processor2);
    }

    @Override
    protected OCTextFieldWithSymbolAutoCompletion<String> createSuiteField() {
        return new OCTextFieldWithSymbolAutoCompletion<String>(this.myProject, new OCTextFieldCompletionProvider<String>((OCFieldAdapter)this.createSuiteAdapter()){

            @NotNull
            public Collection<String> getItems(@NotNull String prefix, boolean cached, CompletionParameters parameters) {
                Supplier<Collection> suggestion = () -> {
                    PrefixMatcher matcher = this.createPrefixMatcher(prefix);
                    return this.collectValuesFromProject(CidrTestWithScopeElementsRunConfigurationEditor.this.myProject, item -> matcher.prefixMatches(this.myAdapter.getName(item)));
                };
                return cached ? OCTestFrameworks.executeWithCachedValuesFast(suggestion) : OCTestFrameworks.executeWithRealValuesSlow(suggestion);
            }

            @Nullable
            public String getPrefix(@NotNull String text, int offset) {
                return this.myAdapter.getPrefix(text, offset);
            }

            @NotNull
            public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
                CompletionResultSet resultSet = super.applyPrefixMatcher(result2, prefix);
                resultSet.stopHere();
                return resultSet;
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
    }

    @NotNull
    protected abstract MyOCFieldAdapter createSuiteAdapter();

    protected static abstract class MyOCFieldAdapter
    implements OCFieldAdapter<String> {
        protected MyOCFieldAdapter() {
        }

        @Override
        @NotNull
        public String getName(String item) {
            return item;
        }

        @Override
        @Contract(value="_ -> null", pure=true)
        public Icon getIcon(String item) {
            return null;
        }

        @Override
        @Contract(value="_ -> null", pure=true)
        public String getTypeText(String item) {
            return null;
        }

        @Override
        @NotNull
        public String getReadableName(String item) {
            return this.getName(item);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            return new SuitePrefixMatcher(prefix);
        }

        @Override
        @NotNull
        public String getPrefix(@NotNull String text, int offset) {
            return text.substring(0, offset);
        }
    }

    protected static class SuitePrefixMatcher
    extends PrefixMatcher {
        public SuitePrefixMatcher(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull String name) {
            return StringUtil.startsWith((CharSequence)name, (CharSequence)this.getPrefix());
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            return new SuitePrefixMatcher(prefix);
        }
    }
}

