/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.execution.Location;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Queue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestInfoSerializer;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestListUpdater
implements Disposable,
ModificationTracker {
    public static final int TEST_DETECTION_PASS_RETRY_TIMEOUT = 100;
    public static final int TEST_DETECTION_PASS_RETRY_AFTER_WA_TIMEOUT = 1000;
    public static final int TEST_DETECTION_PASS_RETRY_TIMEOUT_MAX = 30000;
    public final Ref<Task.Backgroundable> myTask = new Ref();
    public final HashMap<VirtualFile, CidrTestInfoForFile> myIndexedTests = new HashMap();
    public final LinkedList<VirtualFile> myScheduledFiles = new LinkedList();
    public final MergingUpdateQueue myUpdateQueue;
    public final Project myProject;
    public final CidrTestFrameworkBase<?> myFramework;
    private final Queue<Runnable> myRunWhenIndexed = new MyQueue<Runnable>();
    private final Object myRunAfterIndexedLock = new Object();
    private volatile int myMergingTimeSpan;
    private final AtomicBoolean myFirstScanPending = new AtomicBoolean(true);
    private final AtomicBoolean myNeedSaveFirstScanResults = new AtomicBoolean(true);
    private volatile int myTestInfoVersion = 1;
    private volatile int myLocationResolveCount = 0;
    private volatile int mySize = 0;
    private volatile int myIndex = 0;
    private static volatile Boolean ourSchedulingDisabledInTests = null;
    private static volatile boolean ourTaskExecutionDisabledInTests = false;

    CidrTestListUpdater(@NotNull CidrTestFrameworkBase<?> framework, @NotNull Project project2) {
        this.myFramework = framework;
        this.myProject = project2;
        Disposer.register((Disposable)project2, (Disposable)this);
        this.myMergingTimeSpan = 100;
        this.myUpdateQueue = new MergingUpdateQueue(this.myFramework.getFrameworkId() + " update", this.myMergingTimeSpan, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, true);
        ApplicationListener postponeIndexingOnWrite = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                CidrTestListUpdater.this.myUpdateQueue.suspend();
            }

            public void afterWriteActionFinished(@NotNull Object action) {
                CidrTestListUpdater.this.myUpdateQueue.resume();
                CidrTestListUpdater.this.myUpdateQueue.restartTimer();
            }
        };
        ApplicationManager.getApplication().addApplicationListener(postponeIndexingOnWrite, (Disposable)this);
    }

    public void dispose() {
        this.filterTestHoldersAndWriteIndexedTestInfo(true);
        this.myFramework.dropUpdater(this.myProject);
    }

    @NotNull
    public String getId() {
        return this.myFramework.getFrameworkId();
    }

    public void scheduleUpdate(@NotNull VirtualFile fileToScan) {
        if (this.myFramework.markOnlyNotScheduleForUpdate(fileToScan)) {
            return;
        }
        this.doScheduleUpdate(fileToScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScheduleUpdate(@Nullable VirtualFile fileToScan) {
        if (ourSchedulingDisabledInTests == Boolean.TRUE) {
            return;
        }
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
            if (fileToScan != null) {
                this.myScheduledFiles.remove(fileToScan);
                this.myScheduledFiles.addFirst(fileToScan);
            }
            this.mySize = this.myIndex + this.myScheduledFiles.size();
        }
        this.myMergingTimeSpan = 100;
        this.scheduleUpdatePass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexing() {
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            return !this.myScheduledFiles.isEmpty();
        }
    }

    public boolean isIndexed() {
        return !this.isIndexing() && !this.myFirstScanPending.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBulkUpdate(@NotNull HashSet<VirtualFile> mutableForUpdate) {
        boolean needUpdate;
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
            this.myScheduledFiles.forEach(file2 -> mutableForUpdate.remove(file2));
            this.mySize = this.myIndex + this.myScheduledFiles.size();
            this.myScheduledFiles.addAll(mutableForUpdate);
            needUpdate = !this.myScheduledFiles.isEmpty();
        }
        if (needUpdate) {
            this.scheduleUpdatePass();
        }
    }

    private void initFirstScanUnderSyncIfNeed() {
        if (this.myFirstScanPending.compareAndSet(true, false)) {
            CidrTestListUpdater.fillCollectionWithTestFirst(this.myFramework.getPotentialTestHolderRoots(this.myProject), this.myScheduledFiles);
            this.filterTestHoldersAndReadTestInfoForScheduledFiles();
        }
    }

    static void fillCollectionWithTestFirst(@NotNull Collection<VirtualFile> holders, @NotNull LinkedList<VirtualFile> collector) {
        holders.forEach(file2 -> {
            if (StringUtil.containsIgnoreCase((String)file2.getName(), (String)"test")) {
                collector.addFirst((VirtualFile)file2);
            } else {
                collector.addLast((VirtualFile)file2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleUpdatePass() {
        Ref<Task.Backgroundable> ref = this.myTask;
        synchronized (ref) {
            if (!this.myUpdateQueue.isEmpty() || this.myTask.get() != null || ourSchedulingDisabledInTests == Boolean.TRUE) {
                return;
            }
            this.myUpdateQueue.setMergingTimeSpan(this.myMergingTimeSpan);
            this.myTask.set((Object)this.getScanTask());
            CidrTestListUpdater.log(this.getId(), " schedule scan");
            this.myUpdateQueue.queue(new Update(this.getId() + " scan"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Ref<Task.Backgroundable> ref = CidrTestListUpdater.this.myTask;
                    synchronized (ref) {
                        Task.Backgroundable task2 = (Task.Backgroundable)CidrTestListUpdater.this.myTask.get();
                        if (task2 == null) {
                            CidrTestLog.LOG.warn(CidrTestListUpdater.this.getId() + " Warning: lost update");
                            return;
                        }
                        if (!CidrTestListUpdater.this.myFramework.canStartIndexing(CidrTestListUpdater.this.myProject)) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " postpone");
                            CidrTestListUpdater.this.increaseTimeForNextAttempt();
                            CidrTestListUpdater.this.myUpdateQueue.restartTimer();
                            CidrTestListUpdater.this.myUpdateQueue.queue((Update)this);
                            return;
                        }
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            if (!ourTaskExecutionDisabledInTests) {
                                CidrTestListUpdater.executeIndexingInBackground(false, task2);
                            }
                            return;
                        }
                        CidrTestListUpdater.executeIndexingInBackground(Registry.is((String)"cidr.test.framework.showIndexingAsTask"), task2);
                    }
                }
            });
        }
    }

    private static void executeIndexingInBackground(boolean asBackgroundTask, @NotNull Task.Backgroundable task2) {
        if (asBackgroundTask) {
            ProgressManager.getInstance().run((Task)task2);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> task2.run((ProgressIndicator)new ProgressIndicatorBase()));
        }
    }

    @NotNull
    @Contract(value=" -> new")
    private Task.Backgroundable getScanTask() {
        this.myFramework.indexingScheduled(this.myProject);
        return new Task.Backgroundable(this.myProject, CidrBundle.message("test.finding.tests", this.myFramework.getFrameworkId()), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Ref<Task.Backgroundable> ref;
                indicator.setIndeterminate(false);
                indicator.setFraction(CidrTestListUpdater.this.mySize == 0 ? 0.0 : (double)CidrTestListUpdater.this.myIndex / (double)CidrTestListUpdater.this.mySize);
                Iterator<VirtualFile> iterator2 = CidrTestListUpdater.this.getScheduledFilesIterator(indicator);
                try {
                    CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " start");
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> CidrTestListUpdater.this.processTestInfo(iterator2), (ProgressIndicator)indicator);
                    ref = CidrTestListUpdater.this.myTask;
                }
                catch (Throwable throwable) {
                    Ref<Task.Backgroundable> ref2 = CidrTestListUpdater.this.myTask;
                    synchronized (ref2) {
                        if (CidrTestListUpdater.this.myTask.get() == this) {
                            CidrTestListUpdater.this.myTask.set(null);
                        }
                        if (iterator2.hasNext()) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " re-run scheduled");
                            CidrTestListUpdater.this.increaseTimeForNextAttempt();
                            CidrTestListUpdater.this.scheduleUpdatePass();
                        } else {
                            CidrTestListUpdater.this.myIndex = 0;
                            CidrTestListUpdater.this.myFramework.indexingFinished(this.myProject);
                            ApplicationManager.getApplication().executeOnPooledThread(() -> CidrTestListUpdater.this.runAfterIndexing());
                        }
                    }
                    throw throwable;
                }
                synchronized (ref) {
                    if (CidrTestListUpdater.this.myTask.get() == this) {
                        CidrTestListUpdater.this.myTask.set(null);
                    }
                    if (iterator2.hasNext()) {
                        CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " re-run scheduled");
                        CidrTestListUpdater.this.increaseTimeForNextAttempt();
                        CidrTestListUpdater.this.scheduleUpdatePass();
                    } else {
                        CidrTestListUpdater.this.myIndex = 0;
                        CidrTestListUpdater.this.myFramework.indexingFinished(this.myProject);
                        ApplicationManager.getApplication().executeOnPooledThread(() -> CidrTestListUpdater.this.runAfterIndexing());
                    }
                }
            }
        };
    }

    private void increaseTimeForNextAttempt() {
        this.myMergingTimeSpan = MathUtil.clamp((int)(this.myMergingTimeSpan * 2), (int)1000, (int)30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterIndexing() {
        Object object = this.myRunAfterIndexedLock;
        synchronized (object) {
            while (true) {
                Runnable runnable;
                Queue<Runnable> queue2 = this.myRunWhenIndexed;
                synchronized (queue2) {
                    if (this.myRunWhenIndexed.isEmpty()) {
                        break;
                    }
                    runnable = (Runnable)this.myRunWhenIndexed.peekFirst();
                }
                runnable.run();
                queue2 = this.myRunWhenIndexed;
                synchronized (queue2) {
                    this.myRunWhenIndexed.pullFirst();
                }
            }
        }
    }

    protected void processTestInfo(@NotNull Iterator<VirtualFile> iterator2) {
        if (this.myFramework.consumeTestInfo(this.myProject, iterator2, null, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileTestInfoPair -> {
            this.myFramework.initInfo((PsiFile)fileTestInfoPair.first, (CidrTestInfoForFile)((Object)((Object)fileTestInfoPair.second)));
            return true;
        }))) {
            CidrTestListUpdater.log(this.getId(), " scan finished");
            this.filterTestHoldersAndWriteIndexedTestInfo(this.myNeedSaveFirstScanResults.compareAndSet(true, false));
        }
    }

    @NotNull
    protected Iterator<VirtualFile> getScheduledFilesIterator(final @NotNull ProgressIndicator indicator) {
        return new Iterator<VirtualFile>(){
            private VirtualFile myProcessingFile = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                LinkedList<VirtualFile> linkedList = CidrTestListUpdater.this.myScheduledFiles;
                synchronized (linkedList) {
                    if (this.myProcessingFile != null) {
                        if (!CidrTestListUpdater.this.myScheduledFiles.remove(this.myProcessingFile)) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Warning: lost processing file:", this.myProcessingFile);
                        } else {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Processed:", this.myProcessingFile);
                        }
                        this.myProcessingFile = null;
                    }
                    return !CidrTestListUpdater.this.myScheduledFiles.isEmpty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VirtualFile next() {
                LinkedList<VirtualFile> linkedList = CidrTestListUpdater.this.myScheduledFiles;
                synchronized (linkedList) {
                    this.myProcessingFile = !CidrTestListUpdater.this.myScheduledFiles.isEmpty() ? CidrTestListUpdater.this.myScheduledFiles.peek() : null;
                    CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Processing file:", this.myProcessingFile == null ? "(null)" : this.myProcessingFile);
                    if (CidrTestListUpdater.this.mySize > 0 && this.myProcessingFile != null) {
                        indicator.setFraction((double)CidrTestListUpdater.this.myIndex++ / (double)CidrTestListUpdater.this.mySize);
                        indicator.setText2(this.myProcessingFile.getPath());
                    }
                    return this.myProcessingFile;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTestHoldersAndWriteIndexedTestInfo(boolean saveTestInfo) {
        CidrTestLog.LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        Condition<VirtualFile> potentialValidTestHolder = this.myFramework.isPotentialValidTestHolder(this.myProject);
        HashMap<VirtualFile, CidrTestInfoForFile> hashMap = this.myIndexedTests;
        synchronized (hashMap) {
            ArrayList<Map.Entry<VirtualFile, CidrTestInfoForFile>> entries2 = new ArrayList<Map.Entry<VirtualFile, CidrTestInfoForFile>>(this.myIndexedTests.entrySet());
            CidrTestInfoSerializer serializer2 = new CidrTestInfoSerializer(this.myProject, this.myFramework);
            entries2.forEach((Consumer<Map.Entry<VirtualFile, CidrTestInfoForFile>>)((Consumer<Map.Entry>)entry -> {
                VirtualFile virtualFile = (VirtualFile)entry.getKey();
                if (!potentialValidTestHolder.value((Object)virtualFile)) {
                    CidrTestListUpdater.log(this.getId(), " remove info about ", virtualFile);
                    this.myIndexedTests.remove(virtualFile);
                } else if (saveTestInfo) {
                    CidrTestListUpdater.log(this.getId(), " save info about ", virtualFile);
                    serializer2.writeTestInfo(virtualFile, (CidrTestInfoForFile)((Object)((Object)entry.getValue())));
                }
            }));
        }
    }

    public void incTestInfoVersion() {
        ++this.myTestInfoVersion;
    }

    public long getModificationCount() {
        return this.myTestInfoVersion;
    }

    @NotNull
    public List<Location> getLocation(@NotNull Computable<List<Location>> findLocationsInScope) {
        ++this.myLocationResolveCount;
        return CidrTestFrameworkBase.getFromSymbols(Collections.emptyList(), this.myProject, findLocationsInScope);
    }

    public static void log(@NotNull String message, Object ... details) {
        CidrTestLog.LOG.debug(message, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenIndexed(Runnable runnable) {
        Queue<Runnable> queue2 = this.myRunWhenIndexed;
        synchronized (queue2) {
            if (this.myFirstScanPending.get()) {
                this.doScheduleUpdate(null);
            }
            if (this.isIndexing()) {
                this.myRunWhenIndexed.addLast((Object)runnable);
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTestHoldersAndReadTestInfoForScheduledFiles() {
        CidrTestLog.LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            HashSet filesWithActualTestInfo = new HashSet();
            CidrTestInfoSerializer serializer2 = new CidrTestInfoSerializer(this.myProject, this.myFramework);
            this.myScheduledFiles.forEach(vf -> {
                Pair<Boolean, CidrTestInfoForFile> actualAndTestInfo = serializer2.filterTestHoldersAndReadTestInfo((VirtualFile)vf);
                if (actualAndTestInfo != null) {
                    if (actualAndTestInfo.second != null) {
                        this.myIndexedTests.put((VirtualFile)vf, (CidrTestInfoForFile)((Object)((Object)actualAndTestInfo.second)));
                    }
                    if (((Boolean)actualAndTestInfo.first).booleanValue()) {
                        filesWithActualTestInfo.add(vf);
                    }
                }
            });
            this.myScheduledFiles.removeAll(filesWithActualTestInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTestInfo() {
        Object object = this.myTask;
        synchronized (object) {
            this.myUpdateQueue.cancelAllUpdates();
            this.myTask.set(null);
        }
        object = this.myScheduledFiles;
        synchronized (object) {
            this.myIndexedTests.clear();
            this.myFirstScanPending.set(true);
            this.myScheduledFiles.clear();
            this.mySize = 0;
            this.myIndex = 0;
        }
    }

    public Iterator<VirtualFile> getScheduledFilesIterator() {
        return this.getScheduledFilesIterator((ProgressIndicator)new EmptyProgressIndicator());
    }

    public Collection<VirtualFile> getProcessingQueue() {
        return this.myScheduledFiles;
    }

    public void processTestInfoDirectly(@NotNull Iterator<VirtualFile> iterator2) {
        this.processTestInfo(iterator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFirstScanIfNeedDirectly() {
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
        }
    }

    public long getLocationResolveCount() {
        return this.myLocationResolveCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIndexingToFinish() throws TimeoutException {
        if (ourSchedulingDisabledInTests == Boolean.TRUE) {
            return;
        }
        Semaphore s = new Semaphore(1);
        Queue<Runnable> queue2 = this.myRunWhenIndexed;
        synchronized (queue2) {
            if (!this.isIndexing() && this.myRunWhenIndexed.isEmpty()) {
                if (!this.myFirstScanPending.get()) {
                    return;
                }
                this.doScheduleUpdate(null);
            }
            this.myRunWhenIndexed.addLast(() -> ((Semaphore)s).up());
        }
        long limit = 600000L;
        int step = 100;
        while (!s.waitFor((long)step)) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if ((limit -= (long)step) > 0L) continue;
            PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
            throw new TimeoutException();
        }
    }

    public static void setSchedulingDisabledInTests(Boolean schedulingDisabledInTests) {
        if (ourSchedulingDisabledInTests == null || schedulingDisabledInTests == null) {
            ourSchedulingDisabledInTests = schedulingDisabledInTests;
        }
    }

    public static void setTaskExecutionDisabledInTests(boolean taskExecutionDisabledInTests) {
        ourTaskExecutionDisabledInTests = taskExecutionDisabledInTests;
    }

    private static class MyQueue<T>
    extends Queue<T> {
        MyQueue() {
            super(1);
        }

        public T set(int index, T value) {
            throw new IllegalArgumentException("Not supported, see comment above");
        }
    }
}

