/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.disasm.AbstractDisasmDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "()V", "createDataPlaceholder", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "holeRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "fromInstructionList", "", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlock;", "instructions", "Companion", "DisasmBlock", "DisasmBlockImpl", "InstructionDataEntry", "InstructionDataPlaceholder", "intellij.cidr.debugger"})
public abstract class AbstractDisasmDataProvider
implements CidrMemoryData.DataProvider<LLInstruction> {
    private static final Object UNDEFINED;
    public static final Companion Companion;

    @Override
    @NotNull
    public CidrMemoryData.DataPlaceholder<LLInstruction> createDataPlaceholder(@NotNull Address address, @NotNull AddressRange holeRange) {
        AddressRange surroundingRange = AddressUtil.addressRangeInclusive(address.minus(Address.Companion.getCoercing(AbstractDisasmDataProvider.Companion.getFETCH_BYTES_BEFORE())), address.plus(Address.Companion.getCoercing(AbstractDisasmDataProvider.Companion.getFETCH_BYTES_AFTER() - 1)));
        return new InstructionDataPlaceholder(AddressUtil.addressToRange(address, 1L), surroundingRange.intersectWith(holeRange));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DisasmBlock> fromInstructionList(@NotNull List<LLInstruction> instructions) {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = instructions;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List groupedByFunctions2 = AbstractDisasmDataProvider.Companion.groupByContiguous(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LLInstruction it = (LLInstruction)a;
                boolean bl2 = false;
                Comparable comparable = it.getAddress();
                it = (LLInstruction)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Address address = it.getAddress();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)address);
            }
        }), fromInstructionList.groupedByFunctions.2.INSTANCE);
        Iterable $this$map$iv = groupedByFunctions2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$_u24__u24$instructions;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            List instructions2 = (List)$dstr$_u24__u24$instructions.component2();
            DisasmBlockImpl disasmBlockImpl = DisasmBlockImpl.Companion.fromInstructions(((LLInstruction)CollectionsKt.first((List)instructions2)).getFunctionOffset(), instructions2);
            collection.add(disasmBlockImpl);
        }
        return (List)destination$iv$iv;
    }

    static {
        Companion = new Companion(null);
        UNDEFINED = new Object();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001R\u001e\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlock;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getEntries", "()Ljava/util/List;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "getFunctionOffset", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "intellij.cidr.debugger"})
    public static interface DisasmBlock
    extends CidrMemoryData.DataBlock<LLInstruction> {
        @Nullable
        public LLSymbolOffset getFunctionOffset();

        @Override
        @NotNull
        public List<CidrMemoryData.DataEntry<LLInstruction>> getEntries();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0002\u0018\u0000 \r2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0004:\u0001\rB\u001d\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\f\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$AbstractData;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$InstructionDataEntry;", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlock;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "entries", "", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;Ljava/util/List;)V", "getFunctionOffset", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "cloneWith", "Companion", "intellij.cidr.debugger"})
    private static final class DisasmBlockImpl
    extends CidrMemoryData.AbstractData<LLInstruction, InstructionDataEntry, DisasmBlockImpl>
    implements DisasmBlock {
        @Nullable
        private final LLSymbolOffset functionOffset;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public DisasmBlockImpl cloneWith(@NotNull List<InstructionDataEntry> entries2) {
            return new DisasmBlockImpl(this.getFunctionOffset(), entries2);
        }

        @Override
        @Nullable
        public LLSymbolOffset getFunctionOffset() {
            return this.functionOffset;
        }

        public DisasmBlockImpl(@Nullable LLSymbolOffset functionOffset, @NotNull List<InstructionDataEntry> entries2) {
            super(entries2);
            this.functionOffset = functionOffset;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl$Companion;", "", "()V", "fromInstructions", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "instructions", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "intellij.cidr.debugger"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DisasmBlockImpl fromInstructions(@Nullable LLSymbolOffset functionOffset, @NotNull List<LLInstruction> instructions) {
                Collection<InstructionDataEntry> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = instructions;
                LLSymbolOffset lLSymbolOffset = functionOffset;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LLInstruction lLInstruction = (LLInstruction)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    InstructionDataEntry instructionDataEntry = new InstructionDataEntry((LLInstruction)it);
                    collection.add(instructionDataEntry);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                LLSymbolOffset lLSymbolOffset2 = lLSymbolOffset;
                return new DisasmBlockImpl(lLSymbolOffset2, list);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$InstructionDataEntry;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "value", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;)V", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getValue", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "intellij.cidr.debugger"})
    private static final class InstructionDataEntry
    implements CidrMemoryData.DataEntry<LLInstruction> {
        @NotNull
        private final LLInstruction value;

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.getValue().getRange();
        }

        @Override
        @NotNull
        public LLInstruction getValue() {
            return this.value;
        }

        public InstructionDataEntry(@NotNull LLInstruction value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Address getAddress() {
            return CidrMemoryData.DataEntry.DefaultImpls.getAddress(this);
        }

        @Override
        @NotNull
        public Iterable<CidrMemoryData.DataEntry<LLInstruction>> getEntries() {
            return CidrMemoryData.DataEntry.DefaultImpls.getEntries(this);
        }

        @Override
        @NotNull
        public CidrMemoryData.DataEntry<LLInstruction> subRangeImpl(@NotNull AddressRange subRange) {
            return CidrMemoryData.DataEntry.DefaultImpls.subRangeImpl(this, subRange);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$InstructionDataPlaceholder;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "requestRange", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRequestRange", "subRangeImpl", "subRange", "intellij.cidr.debugger"})
    private static final class InstructionDataPlaceholder
    implements CidrMemoryData.DataPlaceholder<LLInstruction> {
        @NotNull
        private final AddressRange range;
        @NotNull
        private final AddressRange requestRange;

        @NotNull
        public InstructionDataPlaceholder subRangeImpl(@NotNull AddressRange subRange) {
            return new InstructionDataPlaceholder(subRange, this.getRequestRange());
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @Override
        @NotNull
        public AddressRange getRequestRange() {
            return this.requestRange;
        }

        public InstructionDataPlaceholder(@NotNull AddressRange range, @NotNull AddressRange requestRange) {
            this.range = range;
            this.requestRange = requestRange;
            AddressUtil.requireNotEmpty((ClosedRange)this.getRange());
            AddressUtil.requireNotEmpty((ClosedRange)this.getRequestRange());
        }

        @Override
        @Nullable
        public LLInstruction getValue() {
            return CidrMemoryData.DataPlaceholder.DefaultImpls.getValue(this);
        }

        @Override
        @NotNull
        public Address getAddress() {
            return CidrMemoryData.DataPlaceholder.DefaultImpls.getAddress(this);
        }

        @Override
        @NotNull
        public Iterable<CidrMemoryData.DataEntry<LLInstruction>> getEntries() {
            return CidrMemoryData.DataPlaceholder.DefaultImpls.getEntries(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\r\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u000b0\f0\u000b\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r0\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$Companion;", "", "()V", "FETCH_BYTES_AFTER", "", "getFETCH_BYTES_AFTER", "()I", "FETCH_BYTES_BEFORE", "getFETCH_BYTES_BEFORE", "UNDEFINED", "groupByContiguous", "", "Lkotlin/Pair;", "K", "T", "", "keySelector", "Lkotlin/Function1;", "intellij.cidr.debugger"})
    public static final class Companion {
        private final int getFETCH_BYTES_BEFORE() {
            return Registry.intValue((String)"cidr.debugger.memory.disasm.fallbackRangeBytes", (int)2048) / 2;
        }

        private final int getFETCH_BYTES_AFTER() {
            return Registry.intValue((String)"cidr.debugger.memory.disasm.fallbackRangeBytes", (int)2048) / 2;
        }

        private final <K, T> List<Pair<K, List<T>>> groupByContiguous(Iterable<? extends T> $this$groupByContiguous, Function1<? super T, ? extends K> keySelector) {
            boolean bl = false;
            List result2 = new ArrayList();
            Object currentKey = UNDEFINED;
            List currentList = null;
            for (T each : $this$groupByContiguous) {
                Object key = keySelector.invoke(each);
                if (Intrinsics.areEqual((Object)currentKey, (Object)key) ^ true) {
                    currentKey = key;
                    boolean bl2 = false;
                    currentList = new ArrayList();
                    result2.add(TuplesKt.to((Object)currentKey, (Object)currentList));
                }
                List list = currentList;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentList");
                }
                list.add(each);
            }
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

