/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class CidrMemberValue
extends CidrPhysicalValue {
    @NotNull
    private final CidrPhysicalValue myParent;
    private final boolean myModifiable;

    public CidrMemberValue(@NotNull LLValue var, @NotNull CidrPhysicalValue parent, boolean modifiable) {
        super(var, parent.getProcess(), parent.getSourcePosition(), parent.getFrame());
        this.myParent = parent;
        this.myModifiable = modifiable;
    }

    public CidrMemberValue(@NotNull LLValue var, @NotNull String displayName2, @NotNull CidrPhysicalValue parent, boolean modifiable) {
        super(var, displayName2, parent.getProcess(), parent.getSourcePosition(), parent.getFrame());
        this.myParent = parent;
        this.myModifiable = modifiable;
    }

    @NotNull
    public CidrPhysicalValue getParent() {
        return this.myParent;
    }

    public XValueModifier getModifier() {
        return this.myModifiable ? new CidrValueModifier(this) : null;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.myParent.getPreparedRenderer().getChildEvaluationExpression(this, lvalue);
    }

    @Override
    @NotNull
    protected CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        CidrDebuggerTypesHelper typesHelper = this.myParent.getTypesHelper();
        return typesHelper.computeSourcePositionAsync(this, indicator);
    }
}

