/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrExceptionBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrExceptionBreakpointType.Properties>> {
    public CidrExceptionBreakpointHandler(CidrDebugProcess process2, Class<? extends CidrExceptionBreakpointType> typeClass) {
        super(process2, typeClass);
    }

    @Override
    protected Collection<LLCodepoint> addCodepointsInBackend(DebuggerDriver driver, XBreakpoint<CidrExceptionBreakpointType.Properties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        CidrExceptionBreakpointType.Properties properties = (CidrExceptionBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null) {
            return Collections.emptyList();
        }
        ArrayList<LLCodepoint> result2 = new ArrayList<LLCodepoint>();
        for (String symbol : CidrExceptionBreakpointHandler.getExceptionSymbols(properties)) {
            try {
                ContainerUtil.addIfNotNull(result2, (Object)driver.addSymbolicBreakpoint(symbol));
            }
            catch (DebuggerCommandException e) {
                return Collections.emptyList();
            }
        }
        return result2;
    }

    private static List<String> getExceptionSymbols(@NotNull CidrExceptionBreakpointType.Properties properties) {
        CidrExceptionBreakpointType.Properties.Type thrown = properties.getWhenThrown();
        ArrayList<String> result2 = new ArrayList<String>(3);
        if (thrown != null) {
            if (thrown == CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION) {
                result2.add("objc_exception_throw");
            } else {
                result2.add("__cxa_throw");
                result2.add("_CxxThrowException");
            }
        }
        if (properties.getWhenCaught() != null) {
            result2.add("__cxa_begin_catch");
        }
        return result2;
    }
}

