/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.formatters;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileProvider;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisSettings;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "Companion", "intellij.cidr.debugger"})
public final class LLDBNatvisSupport
implements CidrDebugProcessConfigurator {
    public static final Companion Companion = new Companion(null);

    @Override
    public void configure(@NotNull CidrDebugProcess process2) {
        DebuggerDriverConfiguration debuggerDriverConfiguration = process2.getRunParameters().getDebuggerDriverConfiguration();
        if (!(debuggerDriverConfiguration instanceof LLDBDriverConfiguration)) {
            debuggerDriverConfiguration = null;
        }
        LLDBDriverConfiguration lLDBDriverConfiguration = (LLDBDriverConfiguration)debuggerDriverConfiguration;
        if (lLDBDriverConfiguration == null) {
            return;
        }
        LLDBDriverConfiguration driverConfiguration = lLDBDriverConfiguration;
        if (driverConfiguration.getHostMachine().getOSType() != OSType.WIN) {
            return;
        }
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        if (!settings.LLDB_NATVIS_RENDERERS_ENABLED) {
            return;
        }
        LLDBNatvisDiagnosticsLevel diagnosticsLevel = settings.LLDB_NATVIS_DIAGNOSTICS_LEVEL;
        process2.postCommand(new CidrDebugProcess.VoidDebuggerCommand(diagnosticsLevel){
            final /* synthetic */ LLDBNatvisDiagnosticsLevel $diagnosticsLevel;

            public final void run(@NotNull DebuggerDriver driver) {
                LLDBNatvisSupport.Companion.initializeNatvis(driver, this.$diagnosticsLevel);
            }
            {
                this.$diagnosticsLevel = lLDBNatvisDiagnosticsLevel;
            }
        });
        boolean bl = false;
        List natvisFilesList = new ArrayList();
        Companion.collectNatvisFilesListFromSettings(process2.getProject(), natvisFilesList);
        for (NatvisFileProvider provider2 : (NatvisFileProvider[])NatvisFileProvider.Companion.getEP_NAME().getExtensions()) {
            provider2.populate(process2, natvisFilesList);
        }
        process2.postCommand(new CidrDebugProcess.VoidDebuggerCommand(natvisFilesList){
            final /* synthetic */ List $natvisFilesList;

            public final void run(@NotNull DebuggerDriver driver) {
                LLDBNatvisSupport.Companion.loadNatvisFiles(driver, this.$natvisFilesList);
            }
            {
                this.$natvisFilesList = list;
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport$Companion;", "", "()V", "collectNatvisFilesListFromSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "fileList", "", "", "initializeNatvis", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "diagnosticsLevel", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisDiagnosticsLevel;", "loadNatvisFiles", "natvisFilesList", "", "intellij.cidr.debugger"})
    public static final class Companion {
        public final void initializeNatvis(@NotNull DebuggerDriver driver, @NotNull LLDBNatvisDiagnosticsLevel diagnosticsLevel) {
            driver.executeConsoleCommand("command script import renderers.jb_lldb_logging_manager");
            driver.executeConsoleCommand("jb_renderers_set_diagnostics_level " + diagnosticsLevel.getLevel());
            driver.executeConsoleCommand("command script import renderers.jb_lldb_declarative_formatters");
            driver.executeConsoleCommand("jb_renderers_loaders_add natvis renderers.jb_lldb_natvis_loader natvis_loader");
        }

        public final void loadNatvisFiles(@NotNull DebuggerDriver driver, @NotNull List<String> natvisFilesList) {
            if (natvisFilesList.isEmpty()) {
                return;
            }
            Iterable $this$forEach$iv = natvisFilesList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path = (String)element$iv;
                boolean bl = false;
                driver.executeConsoleCommand("jb_renderers_load natvis \"" + path + '\"');
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void collectNatvisFilesListFromSettings(@NotNull Project project2, @NotNull List<String> fileList) {
            NatvisSettings settings = NatvisSettings.Companion.getInstance(project2);
            for (Pair<File, Boolean> pair : settings.searchPaths) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void path;
                File file2 = (File)pair.component1();
                boolean enabled = (Boolean)pair.component2();
                if (!enabled) continue;
                Iterable iterable = NatvisFileProvider.Companion.listNatvisFilesInDirectory((File)path);
                List<String> list = fileList;
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file3 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getAbsolutePath();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                list.addAll(collection);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

