/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBTuple
extends ArrayList<Object> {
    private static final List<String> TRUE_STRINGS = Arrays.asList("true", "yes", "on");
    private static final List<String> FALSE_STRINGS = Arrays.asList("false", "no", "off");

    public static GDBTuple of(Object ... elements) {
        GDBTuple tuple = new GDBTuple();
        tuple.addAll(Arrays.asList(elements));
        return tuple;
    }

    @Contract(value="_, _, !null -> !null")
    protected <T> T get(String key, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (!clazz.isInstance(o)) continue;
            return clazz.cast(o);
        }
        return defaultValue;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Contract(value="_, !null -> !null")
    public String getString(String key, @Nullable String defaultValue) {
        return this.get(key, String.class, defaultValue);
    }

    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        return this.getRequiredStringOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
    }

    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        return GDBTuple.checkNotNullOrThrow(this.getString(key), exceptionSupplier);
    }

    @NotNull
    public String getRequiredString(String key) throws ExecutionException {
        return this.getRequiredStringOrThrow(key, ExecutionException::new);
    }

    @Nullable
    public GDBTuple getTuple(String key) {
        return this.get(key, GDBTuple.class, null);
    }

    @NotNull
    public GDBTuple getTupleOrEmpty(String key) {
        GDBTuple value = this.getTuple(key);
        if (value == null) {
            value = new GDBTuple();
        }
        return value;
    }

    @NotNull
    public GDBTuple getRequiredTuple(String key) throws ExecutionException {
        return this.getRequiredTupleOrThrow(key, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        return this.getRequiredTupleOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        return GDBTuple.checkNotNullOrThrow(this.getTuple(key), exceptionSupplier);
    }

    @Nullable
    public Address getAddress(String key) {
        return this.getAddress(key, null);
    }

    @Contract(value="_, !null -> !null")
    public Address getAddress(String key, @Nullable Address defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return GDBTuple.parseAddress(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Address getRequiredAddress(String key) throws ExecutionException {
        return this.getRequiredAddressOrThrow(key, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> Address getRequiredAddressOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseAddress(s, null), GDBTuple.withMessage(exceptionConstructor, () -> CidrDebuggerBundle.message("gdb.malformed.value", s, key, this)));
    }

    @Contract(value="_, !null -> !null")
    private static Address parseAddress(@NotNull String s, @Nullable Address defaultValue) {
        try {
            return Address.parseHexString(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Contract(value="_, !null -> !null")
    public Integer getInteger(String key, @Nullable Integer defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return GDBTuple.parseInteger(s, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInteger(key, defaultValue);
    }

    public int getRequiredInt(String key) throws ExecutionException {
        return this.getRequiredIntOrThrow(key, ExecutionException::new);
    }

    public <X extends Throwable> int getRequiredIntOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseInteger(s, null), GDBTuple.withMessage(exceptionConstructor, () -> CidrDebuggerBundle.message("gdb.malformed.value", s, key, this)));
    }

    @Contract(value="_, !null -> !null")
    private static Integer parseInteger(@NotNull String s, @Nullable Integer defaultValue) {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            String lowerCase = StringUtil.toLowerCase((String)s);
            if (TRUE_STRINGS.contains(lowerCase)) {
                return true;
            }
            if (FALSE_STRINGS.contains(lowerCase)) {
                return false;
            }
            Integer integer = GDBTuple.parseInteger(s, null);
            if (integer != null) {
                return integer != 0;
            }
        }
        return defaultValue;
    }

    @Nullable
    public Location getLocation(String key) {
        return this.getLocation(key, (Location)null);
    }

    @Contract(value="_, !null -> !null")
    public Location getLocation(String key, @Nullable Location defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return Location.tryParse(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Location getRequiredLocation(String key) throws ExecutionException {
        return this.getRequiredLocationOrThrow(key, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> Location getRequiredLocationOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(Location.tryParse(s), GDBTuple.withMessage(exceptionConstructor, () -> CidrDebuggerBundle.message("gdb.malformed.location.string", s, key, this)));
    }

    @Nullable
    public Location getLocation(String pathKey, String lineKey) {
        return this.getLocation(pathKey, lineKey, null);
    }

    @Contract(value="_, _, !null -> !null")
    public Location getLocation(String pathKey, String lineKey, @Nullable Location defaultValue) {
        String path = this.getString(pathKey);
        Integer lineNumber = this.getInteger(lineKey, null);
        if (path != null && lineNumber != null) {
            return Location.fromFileLineNumber(path, lineNumber);
        }
        return defaultValue;
    }

    @NotNull
    public Location getRequiredLocation(String pathKey, String lineKey) throws ExecutionException {
        return this.getRequiredLocationOrThrow(pathKey, lineKey, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> Location getRequiredLocationOrThrow(String pathKey, String lineKey, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String path = GDBTuple.checkNotNullOrThrow(this.getString(pathKey), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(pathKey)));
        int lineNumber = this.getRequiredIntOrThrow(lineKey, exceptionConstructor);
        return Location.fromFileLineNumber(path, lineNumber);
    }

    @NotNull
    public <T> List<T> getAll(String key, Class<T> clazz) {
        SmartList result2 = new SmartList();
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (o == null) continue;
            result2.add(clazz.cast(o));
        }
        return result2;
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(String key, Class<T> clazz) {
        return this.getWithSuccessors(key, clazz, null);
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(String key, Class<T> clazz, @Nullable T defaultValue) {
        SmartList successors = new SmartList();
        Object found2 = null;
        for (Object each : this) {
            if (found2 == null) {
                found2 = GDBTuple.getIfEquals(each, key);
                continue;
            }
            if (each instanceof Pair) break;
            successors.add(clazz.cast(each));
        }
        if (found2 == null) {
            found2 = defaultValue;
        }
        return Pair.create(found2, (Object)successors);
    }

    @NotNull
    private Supplier<String> missingKeyError(String key) {
        return () -> CidrDebuggerBundle.message("gdb.missing.required.key", key, this);
    }

    @NotNull
    private static <X extends Throwable> Supplier<X> withMessage(@NotNull Function<String, ? extends X> exceptionConstructor, @NotNull Supplier<String> messageSupplier) {
        return () -> (Throwable)exceptionConstructor.apply((String)messageSupplier.get());
    }

    @NotNull
    private static <T, X extends Throwable> T checkNotNullOrThrow(@Nullable T value, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value;
    }

    @Nullable
    private static <T> T getIfEquals(@NotNull Object val, String key) {
        if (val.equals(key)) {
            return (T)val;
        }
        if (val instanceof Pair && ((Pair)val).first.equals(key)) {
            return (T)((Pair)val).second;
        }
        return null;
    }

    public static class Location {
        private static final Pattern LOCATION_PATTERN = Pattern.compile("^(.*):(\\d+)$");
        @NotNull
        public final String path;
        public final int line;

        public Location(@NotNull String path, int line) {
            this.path = path;
            this.line = line;
        }

        @NotNull
        public static Location fromFileLineNumber(@NotNull String path, int lineNumber) {
            return new Location(path, lineNumber - 1);
        }

        @Nullable
        public static Location tryParse(@NotNull String locationString) {
            return Location.tryParse(locationString, null);
        }

        @Contract(value="_, !null -> !null")
        public static Location tryParse(@NotNull String locationString, @Nullable Location defaultValue) {
            Matcher matcher = LOCATION_PATTERN.matcher(locationString);
            if (!matcher.matches()) {
                return defaultValue;
            }
            String path = matcher.group(1);
            int lineNumber = Integer.parseInt(matcher.group(2));
            return Location.fromFileLineNumber(path, lineNumber);
        }
    }
}

