/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrOSProcessUtil;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.CidrAttachedDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import org.jetbrains.annotations.NotNull;

public class CidrLocalAttachedDebugProcess
extends CidrAttachedDebugProcess {
    private final int myPid;

    public CidrLocalAttachedDebugProcess(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info, @NotNull XDebugSession session, @NotNull TextConsoleBuilder builder2) throws ExecutionException {
        this(driverConfiguration, info, session, builder2, it -> Filter.EMPTY_ARRAY);
    }

    public CidrLocalAttachedDebugProcess(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info, @NotNull XDebugSession session, @NotNull TextConsoleBuilder builder2, @NotNull ConsoleFilterProvider backendFilterProvider) throws ExecutionException {
        super(CidrLocalAttachedDebugProcess.createRunParameters(driverConfiguration, info), session, builder2, backendFilterProvider);
        this.myPid = info.getPid();
    }

    @NotNull
    private static RunParameters createRunParameters(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info) {
        int pid = info.getPid();
        ArchitectureType architectureType = SystemInfoRt.isWindows ? CidrOSProcessUtil.getProcessArchitectureType(pid) : ArchitectureType.UNKNOWN;
        return new TrivialRunParameters(driverConfiguration, new GeneralCommandLine(), architectureType);
    }

    @Override
    protected int getPidToAttachTo() throws ExecutionException {
        return this.myPid;
    }

    @Override
    public boolean isDetachDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String getRestartDebuggerMessage() {
        return XDebuggerBundle.message((String)"xdebugger.attach.reattach", (Object[])new Object[]{this.myPid});
    }
}

