/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePathToMainFile, @Nullable String relativePathToAdditionalBinaries) {
        return CidrDebuggerPathManager.getBinFile("lldb/" + CidrPathManager.getPlatformRelativePath(relativePathToMainFile), relativePathToAdditionalBinaries == null ? null : "lldb/" + CidrPathManager.getPlatformRelativePath(relativePathToAdditionalBinaries));
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        return CidrDebuggerPathManager.getBinFile("lldb/renderers");
    }

    @NotNull
    public static File getBundledGDBBinary() {
        String platformBin = "gdb/" + CidrPathManager.getPlatformRelativePath("bin");
        return CidrDebuggerPathManager.getBinFile(platformBin + "/" + (SystemInfo.isWindows ? "gdb.exe" : "gdb"), platformBin);
    }

    @NotNull
    public static File getWinbreakFile(@NotNull String name) {
        return CidrDebuggerPathManager.getBinFile("gdb/" + name);
    }

    @NotNull
    public static File getBundledGDBSTLPrettyPrinters() {
        return CidrDebuggerPathManager.getBinFile("gdb/renderers");
    }

    @Nullable
    public static File getOSXSystemPythonBinDir() {
        File pythonBinDir = new File("/System/Library/Frameworks/Python.framework/Versions/Current/bin");
        if (pythonBinDir.exists() && pythonBinDir.isDirectory()) {
            return pythonBinDir;
        }
        return null;
    }

    @NotNull
    private static File getBinFile(String relativePath) {
        return CidrDebuggerPathManager.getBinFile(relativePath, null);
    }

    @NotNull
    private static File getBinFile(String relativePath, @Nullable String relativePathToAdditionalBinaries) {
        return CidrPathManager.getBinPath(CidrDebuggerPathManager.class, "cidr-debugger/bin", relativePath, relativePathToAdditionalBinaries).toFile();
    }
}

