/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerEditorsExtensionBase
implements CidrDebuggerEditorsExtension {
    @Override
    @Nullable
    public Document createDocument(@NotNull Project project2, @NotNull String text, @NotNull XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        PsiElement context2 = this.getContext(project2, sourcePosition);
        if (context2 == null) {
            return null;
        }
        return (Document)WriteAction.computeAndWait(() -> {
            PsiFile fragment = this.createExpressionCodeFragment(project2, text, context2, mode);
            return PsiDocumentManager.getInstance((Project)project2).getDocument(fragment);
        });
    }

    @Nullable
    protected PsiElement getContext(@NotNull Project project2, @NotNull XSourcePosition sourcePosition) {
        return XDebuggerUtil.getInstance().findContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project2, false);
    }

    @NotNull
    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull String text, @NotNull PsiElement context2, @NotNull EvaluationMode mode) {
        return PsiFileFactory.getInstance((Project)project2).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)text);
    }
}

