/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceableExecutionResult<T>
extends ExecutionResult<T> {
    private String myTrace;

    @Override
    public void set(@Nullable T result2) {
        if (super.asCompletableFuture().isDone()) {
            throw new IllegalStateException(this.throwResultAlreadySet());
        }
        super.set(result2);
        this.myTrace = TraceableExecutionResult.currentTrace();
    }

    @Override
    public void setException(Throwable e) {
        if (super.asCompletableFuture().isDone()) {
            throw new IllegalStateException(this.throwResultAlreadySet());
        }
        super.setException(e);
        this.myTrace = TraceableExecutionResult.currentTrace();
    }

    @NotNull
    private String throwResultAlreadySet() {
        if (super.asCompletableFuture().isCompletedExceptionally()) {
            Throwable ex = new Exception();
            try {
                this.get();
            }
            catch (ExecutionException e) {
                ex = e;
            }
            return CidrDebuggerBundle.message("debug.result.already.set.exceptionally", ExceptionUtil.getMessage((Throwable)ex), ExceptionUtil.getThrowableText((Throwable)ex), Thread.currentThread(), this.myTrace);
        }
        if (super.asCompletableFuture().isCancelled()) {
            return CidrDebuggerBundle.message("debug.result.already.cancelled", Thread.currentThread(), this.myTrace);
        }
        return "";
    }

    @Override
    public T get() throws ExecutionException {
        return super.get();
    }

    @NotNull
    private static String currentTrace() {
        return CidrDebuggerBundle.message("debug.current.trace", Thread.currentThread(), DebugUtil.currentStackTrace());
    }
}

