/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrRunConfigurationExtensionsManager
extends RunConfigurationExtensionsManager<CidrRunConfiguration<?, ?>, CidrRunConfigurationExtensionBase> {
    private static final Logger LOG = Logger.getInstance(CidrRunConfigurationExtensionsManager.class);

    public CidrRunConfigurationExtensionsManager() {
        super(CidrRunConfigurationExtensionBase.EP_NAME);
    }

    public static CidrRunConfigurationExtensionsManager getInstance() {
        return (CidrRunConfigurationExtensionsManager)((Object)ServiceManager.getService(CidrRunConfigurationExtensionsManager.class));
    }

    public void patchCommandLineState(@NotNull CidrRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context2) {
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            extension.patchCommandLineState(configuration, runnerSettings, environment, projectBaseDir, state, runnerId, context2);
        }
    }

    @Deprecated
    public final void patchCommandLine(@NotNull CidrRunConfiguration configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        LOG.error("This method is deprecated. Use another signature instead.");
    }

    public void patchCommandLine(@NotNull CidrRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context2) throws ExecutionException {
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            extension.patchCommandLine(configuration, runnerSettings, environment, cmdLine, runnerId, context2);
        }
    }

    @Deprecated
    public void attachExtensionsToProcess(@NotNull CidrRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        LOG.error("This method is deprecated. Use another signature instead.");
    }

    public void attachExtensionsToProcess(@NotNull CidrRunConfiguration configuration, @NotNull ProcessHandler handler, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context2) {
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            extension.attachToProcess(configuration, handler, environment, runnerSettings, runnerId, context2);
        }
    }

    @NotNull
    private List<CidrRunConfigurationExtensionBase> getEnabledExtensions(@NotNull CidrRunConfiguration configuration, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        SmartList extensions = new SmartList();
        for (CidrRunConfigurationExtensionBase extension : this.getApplicableExtensions((RunConfigurationBase)configuration)) {
            if (!extension.isEnabledFor(configuration, environment, runnerSettings)) continue;
            extensions.add(extension);
        }
        return Collections.unmodifiableList(extensions);
    }
}

