/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxCommentProcessorUtil {
    @NotNull
    public static List<PsiComment> getCommentScope(@NotNull PsiElement elt) {
        return DxCommentProcessorUtil.findOCCommentForElementInternal(elt, false);
    }

    @NotNull
    public static List<PsiComment> findOCCommentFor(@Nullable PsiElement element) {
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentForElementInternal(element, true);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project2 = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project2);
            }
            if (symbol != null) {
                PsiElement associatedElement = symbol.locateDefinition(project2);
                comments.addAll(DxCommentProcessorUtil.findOCCommentForElementInternal(associatedElement, true));
            }
        }
        return comments;
    }

    @NotNull
    private static List<PsiComment> findOCCommentForElementInternal(@Nullable PsiElement elt, boolean doxygenOnly) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            return Collections.emptyList();
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return Collections.emptyList();
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        DxCommentProcessorUtil.findPrevComments(elt, comments, doxygenOnly);
        DxCommentProcessorUtil.findInnerComments(elt, comments, doxygenOnly);
        DxCommentProcessorUtil.findNextComments(elt, comments, doxygenOnly);
        return comments;
    }

    private static void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments, boolean doxygenOnly) {
        PsiElement initElement = elt.getFirstChild();
        boolean hasNewLineGap = false;
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            if (element instanceof PsiWhiteSpace) {
                hasNewLineGap = !doxygenOnly && StringUtil.countNewLines((CharSequence)element.getText()) > 1;
                continue;
            }
            if (element instanceof OCMacroCall) continue;
            if (!(element instanceof PsiComment) || hasNewLineGap && !DoxygenUtil.isDoxygenComment((PsiComment)element)) break;
            PsiElement prevSibling = element.getPrevSibling();
            if (!DoxygenUtil.isDoxygenComment((PsiComment)element) && prevSibling != null && (!(prevSibling instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)prevSibling.getText()) <= 0)) break;
            initElement = element;
        }
        if (initElement != null) {
            ArrayList<PsiComment> allComments = new ArrayList<PsiComment>();
            ArrayList<PsiComment> withArrow = new ArrayList<PsiComment>();
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, allComments, doxygenOnly, false, true);
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, withArrow, true, true, true);
            allComments.removeAll(withArrow);
            for (PsiComment comment : allComments) {
                if (doxygenOnly && !DoxygenUtil.isDoxygenComment(comment)) continue;
                comments.add(comment);
            }
        }
    }

    private static void findInnerComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments, boolean doxygenOnly) {
        if (elt instanceof OCClassDeclaration || elt instanceof OCMethod) {
            return;
        }
        ArrayList<PsiComment> firstComments = new ArrayList<PsiComment>();
        DxCommentProcessorUtil.findNextCommentsInternal(elt.getFirstChild(), firstComments, false, false, true);
        List innerComments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class);
        innerComments.removeAll(firstComments);
        for (PsiComment comment : innerComments) {
            if (doxygenOnly && !DoxygenUtil.isDoxygenComment(comment)) continue;
            comments.add(comment);
        }
    }

    private static void findNextComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments, boolean doxygenOnly) {
        if (elt instanceof OCParameterDeclaration || elt.getParent() instanceof OCEnum) {
            DxCommentProcessorUtil.findNextCommentsForCommaSeparatedSequence(elt, comments);
        } else {
            DxCommentProcessorUtil.findNextCommentsInternal(elt.getNextSibling(), comments, doxygenOnly, true, false);
        }
    }

    private static void findNextCommentsInternal(@Nullable PsiElement elt, @NotNull List<PsiComment> comments, boolean doxygenOnly, boolean withArrowOnly, boolean findPrevComments) {
        if (elt == null) {
            return;
        }
        boolean hasNewLineGape = false;
        PsiElement next = elt;
        while (next != null) {
            if (next instanceof PsiWhiteSpace) {
                hasNewLineGape = !doxygenOnly && StringUtil.countNewLines((CharSequence)next.getText()) > (findPrevComments ? 1 : 0);
            } else {
                if (!(next instanceof PsiComment)) break;
                PsiComment comment = (PsiComment)next;
                if (!doxygenOnly) {
                    if (hasNewLineGape && !(findPrevComments ? DoxygenUtil.isDoxygenComment(comment) : DoxygenUtil.hasArrow(comment)) || !findPrevComments && DoxygenUtil.isDoxygenComment(comment) && !DoxygenUtil.hasArrow(comment)) break;
                    comments.add(comment);
                } else if (DoxygenUtil.isDoxygenComment(comment)) {
                    if (withArrowOnly && DoxygenUtil.hasArrow(comment)) {
                        if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                            EOLCommentPack pack = new EOLCommentPack(comment);
                            comments.addAll(pack.getComments());
                            next = pack.getLastComment();
                        } else {
                            comments.add(comment);
                        }
                    } else {
                        if (withArrowOnly) break;
                        comments.add(comment);
                    }
                } else if (withArrowOnly) break;
            }
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
    }

    private static void findNextCommentsForCommaSeparatedSequence(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        boolean waitForArrow = false;
        PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)elt);
        while (next != null) {
            if (!(next instanceof PsiWhiteSpace)) {
                if (next instanceof LeafElement && ((LeafElement)next).getElementType() == OCTokenTypes.COMMA) {
                    waitForArrow = true;
                } else {
                    PsiComment comment;
                    if (!(next instanceof PsiComment) || !DoxygenUtil.isDoxygenComment(comment = (PsiComment)next) || waitForArrow && !DoxygenUtil.hasArrow(comment)) break;
                    if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                        EOLCommentPack pack = new EOLCommentPack(comment);
                        comments.addAll(pack.getComments());
                        next = pack.getLastComment();
                    } else {
                        comments.add(comment);
                    }
                }
            }
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
    }

    private static class EOLCommentPack {
        private final List<PsiComment> comments = new ArrayList<PsiComment>();

        EOLCommentPack(@NotNull PsiComment EOLComment) {
            assert (DoxygenUtil.isDoxygenEOLComment(EOLComment.getText()));
            this.comments.add(EOLComment);
            EOLCommentPack.processEOLCommentPack(EOLComment, this.comments);
        }

        public List<PsiComment> getComments() {
            return this.comments;
        }

        @NotNull
        public PsiComment getLastComment() {
            assert (this.comments.size() > 0);
            return this.comments.get(this.comments.size() - 1);
        }

        private static void processEOLCommentPack(@NotNull PsiComment EOLComment, @NotNull List<PsiComment> pack) {
            PsiDocumentManager manager2 = PsiDocumentManager.getInstance((Project)EOLComment.getProject());
            Document document2 = manager2.getDocument(EOLComment.getContainingFile());
            if (document2 == null) {
                return;
            }
            int startOffset = EOLComment.getTextOffset();
            int lineStartOffset = startOffset - document2.getLineStartOffset(document2.getLineNumber(startOffset));
            for (PsiElement next = EOLComment.getNextSibling(); next != null && (next instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)next.getText()) == 1 || next instanceof PsiComment && EOLCommentPack.processEOLComment((PsiComment)next, document2, lineStartOffset, pack)); next = next.getNextSibling()) {
            }
        }

        private static boolean processEOLComment(@NotNull PsiComment comment, @NotNull Document document2, int offset, @NotNull List<PsiComment> pack) {
            int startOffset;
            int lineStartOffset;
            if (DoxygenUtil.isDoxygenEOLComment(comment.getText()) && offset == (lineStartOffset = (startOffset = comment.getTextOffset()) - document2.getLineStartOffset(document2.getLineNumber(startOffset)))) {
                pack.add(comment);
                return true;
            }
            return false;
        }
    }
}

