/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentGroupImpl;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentTagImpl;
import com.jetbrains.cidr.doxygen.comment.DxCommentProcessorUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxCommentProcessor {
    public static final Set<String> PLAIN_TAGS = ContainerUtil.set((Object[])new String[]{DoxygenCmd.BRIEF.toString()});
    final PsiElement element;
    private static final Result NONE = new Result(null, true);

    public DxCommentProcessor(@Nullable PsiElement element) {
        this.element = element;
    }

    @NotNull
    public DoxygenCommentGroupImpl getCommentGroup() {
        List<PsiNamedElement> params;
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentFor(this.element);
        DoxygenCommentGroupImpl.Builder builder2 = DxCommentProcessor.process(comments);
        PsiElement curElement = this.element;
        if (curElement instanceof OCDeclarator) {
            curElement = curElement.getParent();
        }
        if (curElement instanceof OCCallable && (params = ((OCCallable)curElement).getParameters()) != null) {
            for (PsiNamedElement param : params) {
                List<PsiComment> paramComments;
                DoxygenCommentGroupImpl paramGroup;
                String name = param.getName();
                if ("<unnamed>".equals(name) || (paramGroup = DxCommentProcessor.process(paramComments = DxCommentProcessorUtil.findOCCommentFor((PsiElement)param)).build()).isEmpty()) continue;
                builder2.addTag(new DoxygenCommentTagImpl("param", paramGroup.getOptions(), name, paramGroup.getDescription()));
            }
        }
        return builder2.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static DoxygenCommentGroupImpl.Builder process(@NotNull List<PsiComment> comments) {
        boolean isOptionFound = false;
        DoxygenCommentGroupImpl.Builder builder2 = new DoxygenCommentGroupImpl.Builder();
        Comment comment = new Comment(comments);
        PsiElement element = comment.getFistChild();
        while (true) {
            block9: {
                if (element == null) {
                    return builder2;
                }
                IElementType type = element.getNode().getElementType();
                if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START) {
                    builder2.addText("");
                } else {
                    Result result2;
                    StringBuilder description2;
                    if (type == DxTypes.DOC_COMMENT_DATA) {
                        description2 = new StringBuilder();
                        result2 = DxCommentProcessor.processDocData(comment, element, description2);
                        element = result2.element;
                        builder2.addText(description2.toString());
                        continue;
                    }
                    if (type == DxTypes.TAG_OPTION) {
                        if (!isOptionFound) {
                            isOptionFound = true;
                            builder2.addOptions(element.getNode());
                            break block9;
                        } else {
                            description2 = new StringBuilder();
                            result2 = DxCommentProcessor.processDocData(comment, element, description2);
                            element = result2.element;
                            builder2.addText(description2.toString());
                            continue;
                        }
                    }
                    if (type == DxTypes.DOC_TAG) {
                        Result result3 = DxCommentProcessor.processTag(comment, element, builder2);
                        element = result3.element;
                        continue;
                    }
                }
            }
            element = comment.nextSibling(element);
        }
    }

    @NotNull
    private static Result processDocData(@NotNull Comment comment, @Nullable PsiElement element, @NotNull StringBuilder description2) {
        if (element == null) {
            return NONE;
        }
        IElementType type = element.getNode().getElementType();
        if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
            String text = element.getText().trim();
            description2.append(text);
            return DxCommentProcessor.processDocData(comment, comment.nextSibling(element), description2);
        }
        description2.append(" ");
        while (element != null) {
            IElementType t = element.getNode().getElementType();
            if (t == DxTypes.DOC_TAG) {
                return new Result(element, true);
            }
            if (t == DxTypes.DOC_COMMENT_DATA || t == DxTypes.TAG_OPTION) {
                return DxCommentProcessor.processDocData(comment, element, description2);
            }
            if (t == DxTypes.EOF_DOC_COMMENT_START || t == TokenType.WHITE_SPACE) {
                Result result2 = DxCommentProcessor.processWS(comment, element);
                if (!result2.proceed) {
                    return result2;
                }
                element = result2.element;
                continue;
            }
            element = comment.nextSibling(element);
        }
        return NONE;
    }

    @NotNull
    private static Result processTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull DoxygenCommentGroupImpl.Builder builder2) {
        DxDocTag tag = (DxDocTag)element;
        String name = tag.getName();
        if (DoxygenCmd.SURROUND_TAGS.containsKey(name)) {
            element = DxCommentProcessor.processSurroundTag(comment, element, builder2);
            return new Result(element, true);
        }
        if (DoxygenCmd.SURROUND_TAGS.containsValue(name)) {
            element = comment.nextSibling(element);
            return new Result(element, true);
        }
        DoxygenCommentTagImpl curTag = new DoxygenCommentTagImpl(tag);
        builder2.addTag(curTag);
        element = comment.nextSibling(element);
        while (element != null) {
            IElementType type = element.getNode().getElementType();
            if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
                StringBuilder description2 = new StringBuilder();
                Result result2 = DxCommentProcessor.processDocData(comment, element, description2);
                curTag.addText(description2.toString().trim());
                element = result2.element;
                if (result2.proceed) continue;
                return result2;
            }
            if (type == DxTypes.DOC_TAG) {
                if (!PLAIN_TAGS.contains(name) && DoxygenCmd.SURROUND_TAGS.containsKey(((DxDocTag)element).getName())) {
                    element = DxCommentProcessor.processSurroundTag(comment, element, curTag);
                    continue;
                }
                return new Result(element, true);
            }
            if (type == DxTypes.EOF_DOC_COMMENT_START || type == TokenType.WHITE_SPACE) {
                Result result3 = DxCommentProcessor.processWS(comment, element);
                element = result3.element;
                if (result3.proceed) continue;
                return result3;
            }
            element = comment.nextSibling(element);
        }
        return NONE;
    }

    @Nullable
    private static PsiElement processSurroundTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull ComplexItemBuilder builder2) {
        DoxygenCommentTagImpl tag = new DoxygenCommentTagImpl((DxDocTag)element);
        String stopName = DoxygenCmd.SURROUND_TAGS.get(tag.getName());
        builder2.addTag(tag);
        StringBuilder description2 = new StringBuilder();
        element = comment.nextSibling(element);
        while (element != null) {
            String text = element.getText();
            IElementType type = element.getNode().getElementType();
            if (type == TokenType.WHITE_SPACE) {
                int count = StringUtil.getLineBreakCount((CharSequence)text);
                if (count > 0 && text.contains("*")) {
                    for (int i2 = 0; i2 < count; ++i2) {
                        if (description2.length() <= 0) continue;
                        description2.append("\n");
                    }
                } else {
                    description2.append(text);
                }
            } else if (type == DxTypes.EOF_DOC_COMMENT_START) {
                if (description2.length() > 0) {
                    description2.append("\n");
                }
            } else {
                if (type == DxTypes.DOC_TAG && stopName.equals(((DxDocTag)element).getName()) || type == DxTypes.DOC_COMMENT_END) break;
                description2.append(text);
            }
            element = comment.nextSibling(element);
        }
        String descriptionText = StringUtil.trimTrailing((String)description2.toString());
        tag.addText(StringUtil.trimStart((String)descriptionText, (String)"\n"));
        if (element != null) {
            return comment.nextSibling(element);
        }
        return null;
    }

    @NotNull
    private static Result processWS(@NotNull Comment comment, @NotNull PsiElement element) {
        int breaks = 0;
        while (element != null) {
            IElementType t = element.getNode().getElementType();
            if (t == TokenType.WHITE_SPACE) {
                breaks += StringUtil.getLineBreakCount((CharSequence)element.getText());
            } else {
                if (t != DxTypes.EOF_DOC_COMMENT_START) break;
                ++breaks;
            }
            element = comment.nextSibling(element);
        }
        boolean proceed = breaks <= 1;
        return new Result(element, proceed);
    }

    private static class Comment {
        private int idx = 0;
        private final List<PsiComment> comments;

        Comment(@NotNull List<PsiComment> comments) {
            this.comments = comments;
        }

        @Nullable
        public PsiElement getFistChild() {
            return this.getFirstElementChild(0);
        }

        @Nullable
        private PsiElement getFirstElementChild(int index) {
            DxDocComment docComment;
            if (index < this.comments.size() && (docComment = DoxygenUtil.convertToDoxygen(this.comments.get(index))) != null) {
                return docComment.getFirstChild();
            }
            return null;
        }

        public PsiElement nextSibling(@NotNull PsiElement element) {
            PsiElement next = element.getNextSibling();
            if (next == null) {
                return this.getFirstElementChild(++this.idx);
            }
            return next;
        }
    }

    private static class Result {
        public final PsiElement element;
        public final boolean proceed;

        Result(PsiElement element, boolean proceed) {
            this.element = element;
            this.proceed = proceed;
        }
    }
}

