/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class DomFileMetaData
extends AbstractExtensionPointBean {
    static final ExtensionPointName<DomFileMetaData> EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileMetaData");
    @Attribute(value="implementation")
    @RequiredElement
    public String implementation;
    @Attribute(value="rootTagName")
    @Nullable
    public String rootTagName;
    @Attribute(value="domVersion")
    public int domVersion;
    @Attribute(value="stubVersion")
    @Nullable
    public Integer stubVersion;
    volatile DomFileDescription<?> lazyInstance;

    public DomFileMetaData() {
    }

    public DomFileMetaData(DomFileDescription<?> description2) {
        this.lazyInstance = description2;
        this.implementation = description2.getClass().getName();
        this.rootTagName = description2.acceptsOtherRootTagNames() ? null : description2.getRootTagName();
        this.domVersion = description2.getVersion();
        this.stubVersion = description2.hasStubs() ? Integer.valueOf(description2.getStubVersion()) : null;
    }

    DomFileDescription<?> getDescription() {
        DomFileDescription instance2 = this.lazyInstance;
        if (instance2 == null) {
            try {
                instance2 = (DomFileDescription)DomFileMetaData.instantiate((Class)this.findExtensionClass(this.implementation), (PicoContainer)ApplicationManager.getApplication().getPicoContainer());
                if (StringUtil.isEmpty((String)this.rootTagName)) {
                    if (!instance2.acceptsOtherRootTagNames()) {
                        throw new PluginException(this.implementation + " should either specify 'rootTagName' in XML, or return true from 'acceptsOtherRootTagNames'", this.getPluginId());
                    }
                } else if (!this.rootTagName.equals(instance2.getRootTagName())) {
                    throw new PluginException(this.implementation + " XML declaration should have '" + instance2.getRootTagName() + "' for 'rootTagName'", this.getPluginId());
                }
                DomApplicationComponent.getInstance().initDescription(instance2);
                this.lazyInstance = instance2;
            }
            catch (PluginException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e, this.getPluginId());
            }
        }
        return instance2;
    }

    public boolean hasStubs() {
        return this.stubVersion != null;
    }
}

