/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.TestCaseLoader;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlagListener;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.SkipWithExecutionPolicy;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaTestExecutionPolicy
implements TestModeFlagListener {
    private static IdeaTestExecutionPolicy ourCurrent = null;

    protected IdeaTestExecutionPolicy() {
        TestModeFlags.addListener((TestModeFlagListener)this);
    }

    public void setUp(Project project2, Disposable testRootDisposable, String testDataPath) {
    }

    public TempDirTestFixture createTempDirTestFixture() {
        return new LightTempDirTestFixtureImpl(true);
    }

    public boolean runInDispatchThread() {
        return true;
    }

    public void testFileConfigured(@NotNull PsiFile file2) {
    }

    public void testDirectoryConfigured(@NotNull PsiDirectory directory) {
    }

    public void beforeCheckResult(@NotNull PsiFile file2) {
    }

    public String getHomePath() {
        return null;
    }

    @Nullable
    public String getPerTestTempDirName() {
        return null;
    }

    public void waitForHighlighting(@NotNull Project project2, @NotNull Editor editor) {
    }

    public void inspectionToolEnabled(@NotNull Project project2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull Disposable disposable) {
    }

    public void testModeFlagChanged(@NotNull Key<?> key, @Nullable Object value) {
    }

    @Nullable
    public static IdeaTestExecutionPolicy current() {
        if (ourCurrent != null) {
            return ourCurrent;
        }
        String policyClassName = System.getProperty("idea.test.execution.policy");
        if (policyClassName == null) {
            return null;
        }
        try {
            Class<?> policyClass = Class.forName(policyClassName);
            ourCurrent = (IdeaTestExecutionPolicy)policyClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return ourCurrent;
    }

    public static String getHomePathWithPolicy() {
        String policyHomePath;
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && (policyHomePath = policy.getHomePath()) != null) {
            return policyHomePath;
        }
        return PathManager.getHomePath();
    }

    public boolean canRun(Class<? extends UsefulTestCase> testCaseClass) {
        IdeaTestExecutionPolicy current = IdeaTestExecutionPolicy.current();
        if (current == null) {
            return true;
        }
        SkipWithExecutionPolicy annotation = (SkipWithExecutionPolicy)TestCaseLoader.getAnnotationInHierarchy(testCaseClass, SkipWithExecutionPolicy.class);
        return annotation == null || !annotation.value().equals(current.getName());
    }

    protected abstract String getName();
}

