/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowHeadlessManagerImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Function;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode<?> kid, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        VirtualFile[] result2;
        if (kid instanceof BasePsiNode) {
            Object value = kid.getValue();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value));
            return new VirtualFile[]{virtualFile};
        }
        if (converterFunction != null && (result2 = (VirtualFile[])converterFunction.fun(kid)) != null) {
            return result2;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public static void collect(AbstractTreeNode node2, MultiValuesMap<VirtualFile, AbstractTreeNode<?>> map2, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        Object[] kids;
        for (Object kid1 : kids = structure.getChildElements((Object)node2)) {
            VirtualFile[] files;
            ProjectViewNode kid = (ProjectViewNode)kid1;
            for (VirtualFile vFile : files = ProjectViewTestUtil.getFiles(kid, converterFunction)) {
                map2.put((Object)vFile, (Object)kid);
                for (ProjectViewNode eachParent = (ProjectViewNode)kid.getParent(); eachParent != null; eachParent = (ProjectViewNode)eachParent.getParent()) {
                    map2.put((Object)vFile, (Object)eachParent);
                }
            }
            ProjectViewTestUtil.collect((AbstractTreeNode)kid, map2, structure, converterFunction);
        }
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        MultiValuesMap map2 = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)rootElement, map2, structure, converterFunction);
        for (VirtualFile eachFile : map2.keySet()) {
            Collection nodes = map2.values();
            for (AbstractTreeNode node2 : nodes) {
                boolean expected;
                ProjectViewNode eachNode = (ProjectViewNode)node2;
                boolean actual = eachNode.contains(eachFile);
                if (actual == (expected = map2.get((Object)eachFile).contains(eachNode))) continue;
                Assert.fail((String)("file=" + eachFile + "\n node=" + eachNode.getTestPresentation() + " expected:" + expected));
            }
        }
    }

    public static void checkGetParentConsistency(AbstractTreeStructure structure, Object from) {
        Object[] childElements;
        for (Object childElement : childElements = structure.getChildElements(from)) {
            Assert.assertSame((Object)from, (Object)structure.getParentElement(childElement));
            ProjectViewTestUtil.checkGetParentConsistency(structure, childElement);
        }
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.assertStructureEqual(structure, expected, 27, null, structure.getRootElement(), printInfo);
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, int maxRowCount, @Nullable Comparator comparator, Object rootNode, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.checkGetParentConsistency(structure, rootNode);
        String actual = PlatformTestUtil.print(structure, rootNode, 0, comparator, maxRowCount, ' ', printInfo).toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static boolean isExpanded(PsiElement element, AbstractProjectViewPSIPane pane) {
        return null != ProjectViewTestUtil.getVisiblePath(element, pane);
    }

    @Nullable
    public static TreePath getVisiblePath(@NotNull PsiElement element, @NotNull AbstractProjectViewPSIPane pane) {
        PlatformTestUtil.waitWhileBusy(pane.getTree());
        return TreeUtil.visitVisibleRows((JTree)pane.getTree(), path -> {
            AbstractTreeNode node2 = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path);
            return node2 != null && element.equals(node2.getValue()) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
        });
    }

    public static void setupImpl(@NotNull Project project2, boolean loadPaneExtensions) {
        ToolWindowHeadlessManagerImpl toolWindowManager = (ToolWindowHeadlessManagerImpl)ToolWindowManager.getInstance((Project)project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Project");
        if (toolWindow == null) {
            for (ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!bean.id.equals("Project")) continue;
                toolWindow = toolWindowManager.doRegisterToolWindow(bean.id);
                break;
            }
        }
        assert (toolWindow != null);
        ((ProjectViewImpl)ProjectView.getInstance((Project)project2)).setupImpl(toolWindow, loadPaneExtensions);
    }
}

