/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchTemplateDocumentationProvider
extends AbstractDocumentationProvider {
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof Configuration) {
            return new ConfigurationElement((Configuration)object, psiManager);
        }
        return null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof ConfigurationElement)) {
            return null;
        }
        Configuration configuration = ((ConfigurationElement)element).getConfiguration();
        return "<div class='definition'><pre>" + StringUtil.escapeXmlEntities((String)configuration.getName()) + "</pre></div>" + "<div class='content'>" + StringUtil.escapeXmlEntities((String)configuration.getMatchOptions().getSearchPattern()) + "</div>";
    }

    private static class ConfigurationElement
    extends FakePsiElement {
        @NotNull
        private final Configuration myConfiguration;
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private final DummyHolder myDummyHolder;

        ConfigurationElement(@NotNull Configuration configuration, @NotNull PsiManager psiManager) {
            this.myConfiguration = configuration;
            this.myPsiManager = psiManager;
            this.myDummyHolder = DummyHolderFactory.createHolder((PsiManager)this.myPsiManager, null);
        }

        @NotNull
        public Configuration getConfiguration() {
            return this.myConfiguration;
        }

        public PsiElement getParent() {
            return this.myDummyHolder;
        }

        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    return myConfiguration.getName();
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return null;
                }
            };
        }

        public PsiManager getManager() {
            return this.myPsiManager;
        }
    }
}

