/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeChooser
extends ComboBoxAction
implements DumbAware {
    private final List<FileTypeInfo> myFileTypeInfos = FileTypeChooser.createFileTypeInfos();
    private FileTypeInfo mySelectedItem = this.myFileTypeInfos.get(0);
    private Consumer<? super FileTypeInfo> myConsumer;

    public FileTypeChooser() {
        this.setSmallVariant(false);
    }

    public void setFileTypeInfoConsumer(@Nullable Consumer<? super FileTypeInfo> consumer) {
        this.myConsumer = consumer;
    }

    private static List<FileTypeInfo> createFileTypeInfos() {
        ArrayList<LanguageFileType> types = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        types.sort((o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (LanguageFileType fileType : types) {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile != null);
            Language language = fileType.getLanguage();
            ArrayList<PatternContext> patternContexts = new ArrayList<PatternContext>(profile.getPatternContexts());
            if (!patternContexts.isEmpty()) {
                infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(0), false));
                for (int i2 = 1; i2 < patternContexts.size(); ++i2) {
                    infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(i2), true));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, language, null, false));
            ArrayList<Language> dialects = new ArrayList<Language>(language.getDialects());
            dialects.sort(Comparator.comparing(Language::getDisplayName));
            for (Language dialect : dialects) {
                if (!profile.isMyLanguage(dialect)) continue;
                infos.add(new FileTypeInfo(fileType, dialect, null, true));
            }
        }
        return infos;
    }

    public void setSelectedItem(@NotNull LanguageFileType type, @Nullable Language dialect, @Nullable PatternContext context2) {
        for (FileTypeInfo info : this.myFileTypeInfos) {
            if (!info.isEqualTo(type, dialect, context2)) continue;
            this.setSelectedItem(info);
            return;
        }
    }

    private void setSelectedItem(FileTypeInfo info) {
        this.mySelectedItem = info;
        if (this.myConsumer != null) {
            this.myConsumer.accept(info);
        }
    }

    public FileTypeInfo getSelectedItem() {
        return this.mySelectedItem;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setIcon(this.mySelectedItem.getFileType().getIcon());
        presentation.setText(this.mySelectedItem.getText());
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JPanel panel2 = new JPanel(new BorderLayout(1, 0));
        ComboBoxAction.ComboBoxButton button = this.createComboBoxButton(presentation);
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        JBLabel label = new JBLabel(textWithMnemonic.getText());
        label.setLabelFor((Component)button);
        int mnemonic = textWithMnemonic.getMnemonic();
        button.setMnemonic(mnemonic);
        panel2.add((Component)label, "West");
        panel2.add((Component)button, "Center");
        return panel2;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (FileTypeInfo fileTypeInfo : this.myFileTypeInfos) {
            group.add((AnAction)new FileTypeInfoAction(fileTypeInfo));
        }
        return group;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return action -> ((FileTypeInfoAction)((Object)action)).getFileTypeInfo() == this.mySelectedItem;
    }

    private class FileTypeInfoAction
    extends DumbAwareAction {
        private final FileTypeInfo myFileTypeInfo;

        FileTypeInfoAction(FileTypeInfo fileTypeInfo) {
            this.myFileTypeInfo = fileTypeInfo;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(fileTypeInfo.isNested() ? null : fileTypeInfo.getFileType().getIcon());
            presentation.setText(fileTypeInfo.isNested() ? "    " + fileTypeInfo.getText() : fileTypeInfo.getText());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileTypeChooser.this.setSelectedItem(this.myFileTypeInfo);
        }

        FileTypeInfo getFileTypeInfo() {
            return this.myFileTypeInfo;
        }
    }
}

