/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class TestModeOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final StringBuilder builder = new StringBuilder();
    private boolean myTransactionStarted = false;
    private final List<String> myWords = new SmartList();

    TestModeOptimizingSearchHelper() {
    }

    @Override
    public boolean doOptimizing() {
        return true;
    }

    private void append(String word, String prefix) {
        this.myWords.add(prefix + word);
        this.myTransactionStarted = true;
    }

    @Override
    protected void doAddSearchWordInCode(@NotNull String word) {
        this.append(word, "in code:");
    }

    @Override
    protected void doAddSearchWordInText(@NotNull String word) {
        this.append(word, "in text:");
    }

    @Override
    protected void doAddSearchWordInComments(@NotNull String word) {
        this.append(word, "in comments:");
    }

    @Override
    protected void doAddSearchWordInLiterals(@NotNull String word) {
        this.append(word, "in literals:");
    }

    @Override
    public void endTransaction() {
        if (!this.myTransactionStarted) {
            return;
        }
        this.myTransactionStarted = false;
        super.endTransaction();
        Collections.sort(this.myWords);
        this.builder.append('[');
        boolean bar = false;
        for (String word : this.myWords) {
            if (bar) {
                this.builder.append('|');
            } else {
                bar = true;
            }
            this.builder.append(word);
        }
        this.builder.append(']');
        this.myWords.clear();
    }

    @Override
    public boolean isScannedSomething() {
        return false;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getFilesSetToScan() {
        assert (!this.myTransactionStarted);
        return Collections.emptySet();
    }

    public String getSearchPlan() {
        assert (!this.myTransactionStarted);
        String plan = this.builder.toString();
        this.builder.setLength(0);
        return plan;
    }
}

