/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.XmlErrorBundle;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.XmlMatchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.XmlCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.XmlCompilingVisitor;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructuralSearchProfile
extends StructuralSearchProfile {
    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        new XmlCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        return new XmlMatchingVisitor(globalVisitor);
    }

    @Override
    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME;
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        return element instanceof XmlText ? element.getText().trim() : super.getTypedVarString(element);
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        return element -> XmlMatchUtil.isWhiteSpace(element) || element instanceof PsiErrorElement;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new XmlCompiledPattern();
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        return language instanceof XMLLanguage;
    }

    @Override
    public PsiElement @NotNull [] createPatternTree(@NonNls @NotNull String text, @NotNull PatternTreeContext context2, @NotNull LanguageFileType fileType, @NotNull Language language, String contextId, @NotNull Project project2, boolean physical) {
        text = context2 == PatternTreeContext.File ? text : "<QQQ>" + text + "</QQQ>";
        String fileName = "dummy." + fileType.getDefaultExtension();
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), physical, true);
        XmlDocument document2 = HtmlUtil.getRealXmlDocument((XmlDocument)((XmlFile)fileFromText).getDocument());
        if (context2 == PatternTreeContext.File) {
            return new PsiElement[]{document2};
        }
        assert (document2 != null);
        XmlTag rootTag = document2.getRootTag();
        assert (rootTag != null);
        XmlTagChild[] children = rootTag.getValue().getChildren();
        return children.length == 1 && children[0] instanceof XmlText ? children[0].getChildren() : children;
    }

    @Override
    public PsiElement extendMatchedByDownUp(PsiElement node2) {
        PsiElement parent;
        if (XmlUtil.isXmlToken((PsiElement)node2, (IElementType)XmlTokenType.XML_DATA_CHARACTERS) && (parent = node2.getParent()).getTextRange().equals((Object)node2.getTextRange())) {
            return parent;
        }
        return super.extendMatchedByDownUp(node2);
    }

    @Override
    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return XmlContextType.class;
    }

    @Override
    @NotNull
    public LanguageFileType detectFileType(@NotNull PsiElement context2) {
        Language contextLanguage;
        PsiFile file2 = context2 instanceof PsiFile ? (PsiFile)context2 : context2.getContainingFile();
        Language language = contextLanguage = context2 instanceof PsiFile ? null : context2.getLanguage();
        if (file2.getLanguage() == HTMLLanguage.INSTANCE || file2.getFileType() == StdFileTypes.JSP && contextLanguage == HTMLLanguage.INSTANCE) {
            return StdFileTypes.HTML;
        }
        return StdFileTypes.XML;
    }

    @Override
    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options2) {
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        return new XmlReplaceHandler(project2, replaceOptions);
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return XmlPredefinedConfigurations.createPredefinedTemplates();
    }

    private static final class XmlPredefinedConfigurations {
        private XmlPredefinedConfigurations() {
        }

        static Configuration[] createPredefinedTemplates() {
            return new Configuration[]{PredefinedConfigurationUtil.createSearchTemplateInfo("xml tag", "<'a/>", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute", "<'_tag 'attribute=\"'_value\"/>", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute", "<'_tag 'attribute />", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute value", "<'_tag '_attribute=\"'value\"/>", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute value", "<'_tag '_attribute='value />", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml/html tag value", "<table>'_content*</table>", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<ul> or <ol>", "<'_tag:[regex( ul|ol )] />", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<li> not contained in <ul> or <ol>", "[!within( <ul> or <ol> )]<li />", XmlPredefinedConfigurations.getHtmlXml(), StdFileTypes.HTML)};
        }

        private static String getHtmlXml() {
            return SSRBundle.message("xml_html.category", new Object[0]);
        }
    }

    private static class XmlReplaceHandler
    extends StructuralReplaceHandler {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ReplaceOptions myReplaceOptions;

        XmlReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
            this.myProject = project2;
            this.myReplaceOptions = replaceOptions;
        }

        @Override
        public void replace(ReplacementInfo info, ReplaceOptions options2) {
            PsiElement elementToReplace = StructuralSearchUtil.getPresentableElement(info.getMatch(0));
            assert (elementToReplace != null);
            String replacementToMake = info.getReplacement();
            PsiElement elementParent = elementToReplace.getParent();
            boolean listContext = elementParent instanceof XmlTag;
            if (listContext) {
                this.doReplaceInContext(info, elementToReplace, replacementToMake, elementParent);
            } else {
                PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, this.myReplaceOptions.getMatchOptions().getFileType(), this.myProject);
                if (replacements.length > 0) {
                    PsiElement replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, replacements, replacementToMake, elementParent);
                    Replacer.handleComments(elementToReplace, replacement, info);
                    elementToReplace.replace(replacement);
                } else {
                    elementToReplace.delete();
                }
            }
        }

        private void doReplaceInContext(ReplacementInfo info, PsiElement elementToReplace, String replacementToMake, PsiElement elementParent) {
            PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, this.myReplaceOptions.getMatchOptions().getFileType(), this.myProject);
            if (replacements.length > 0 && !(replacements[0] instanceof XmlAttribute) && !(replacements[0] instanceof XmlTagChild)) {
                replacements = new PsiElement[]{replacements[0].getParent()};
            }
            if (replacements.length > 1) {
                elementParent.addRangeBefore(replacements[0], replacements[replacements.length - 1], elementToReplace);
            } else if (replacements.length == 1) {
                Replacer.handleComments(elementToReplace, replacements[0], info);
                try {
                    elementParent.addBefore(replacements[0], elementToReplace);
                }
                catch (IncorrectOperationException e) {
                    elementToReplace.replace(replacements[0]);
                }
            }
            int matchSize = info.getMatchesCount();
            for (int i2 = 0; i2 < matchSize; ++i2) {
                PsiElement match = info.getMatch(i2);
                if (match == null) continue;
                PsiElement element = StructuralSearchUtil.getPresentableElement(match);
                PsiElement prevSibling = element.getPrevSibling();
                element.getParent().deleteChildRange(XmlMatchUtil.isWhiteSpace(prevSibling) ? prevSibling : element, element);
            }
        }
    }

    static class ValidatingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute && XmlErrorBundle.message((String)"expected.attribute.eq.sign", (Object[])new Object[0]).equals(errorDescription)) {
                return;
            }
            if (parent instanceof XmlTag && XmlErrorBundle.message((String)"named.element.is.not.closed", (Object[])new Object[]{((XmlTag)parent).getName()}).equals(errorDescription)) {
                return;
            }
            throw new MalformedPatternException(errorDescription);
        }
    }
}

