/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");
    @NonNls
    protected static final String PATTERN_PLACEHOLDER = "$$PATTERN_PLACEHOLDER$$";

    public abstract void compile(PsiElement[] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    @NotNull
    public abstract NodeFilter getLexicalNodesFilter();

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    @NotNull
    public List<MatchPredicate> getCustomPredicates(MatchVariableConstraint constraint, String name, MatchOptions options2) {
        return Collections.emptyList();
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context2, @NotNull LanguageFileType fileType, @NotNull Language language, @Nullable String contextId, @NotNull Project project2, boolean physical) {
        return this.doCreatePatternTree(text, context2, fileType, language, project2, physical, this.getContext(text, language, contextId));
    }

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternContextInfo contextInfo, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project2, boolean physical) {
        String contextConstraint = contextInfo.getContextConstraint();
        if (StringUtil.isEmpty((String)contextConstraint)) {
            PatternContext patternContext = contextInfo.getPatternContext();
            String contextId = patternContext != null ? patternContext.getId() : null;
            return this.createPatternTree(text, contextInfo.getTreeContext(), fileType, language, contextId, project2, physical);
        }
        return this.doCreatePatternTree(text, contextInfo.getTreeContext(), fileType, language, project2, physical, this.getContextByConstraint(contextConstraint, project2));
    }

    @NotNull
    private PsiElement[] doCreatePatternTree(@NotNull String text, @NotNull PatternTreeContext context2, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project2, boolean physical, String strContext) {
        String placeholderName = this.getPlaceholderVarName();
        String patternInContext = context2 == PatternTreeContext.File ? text : strContext.replace(placeholderName, text);
        String name = "__dummy." + fileType.getDefaultExtension();
        PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText(name, language, (CharSequence)patternInContext, physical, true);
        if (file2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (context2 == PatternTreeContext.File) {
            return new PsiElement[]{file2};
        }
        int offset = strContext.indexOf(placeholderName);
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement topElement = element;
        int patternLength = text.length();
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element.getTextRange().getStartOffset() != offset || element.getTextLength() > patternLength) continue;
            topElement = element;
        }
        if (topElement instanceof PsiFile) {
            return topElement.getChildren();
        }
        SmartList result2 = new SmartList();
        result2.add(topElement);
        int endOffset = offset + patternLength;
        for (topElement = topElement.getNextSibling(); topElement != null && topElement.getTextRange().getEndOffset() <= endOffset; topElement = topElement.getNextSibling()) {
            result2.add(topElement);
        }
        return result2.toArray(PsiElement.EMPTY_ARRAY);
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        return Collections.emptyList();
    }

    @NotNull
    protected String getPlaceholderVarName() {
        return PATTERN_PLACEHOLDER;
    }

    @NotNull
    protected String getContext(@NotNull String pattern, @Nullable Language language, @Nullable String contextId) {
        return this.getPlaceholderVarName();
    }

    @NotNull
    private String getContextByConstraint(@NotNull String contextConstraint, @NotNull Project project2) {
        Configuration configuration = ConfigurationManager.getInstance(project2).findConfigurationByName(contextConstraint);
        return configuration != null ? configuration.getMatchOptions().getSearchPattern() : this.getPlaceholderVarName();
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(Project project2, String text, String contextId) {
        return null;
    }

    public String getCodeFragmentText(PsiFile fragment) {
        return fragment.getText();
    }

    @NotNull
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    @Nullable
    public LanguageFileType detectFileType(@NotNull PsiElement context2) {
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        return null;
    }

    public boolean supportsShortenFQNames() {
        return false;
    }

    public boolean supportsUseStaticImports() {
        return false;
    }

    public void checkSearchPattern(CompiledPattern pattern) {
    }

    public void checkReplacementPattern(Project project2, ReplaceOptions options2) {
        String fileType = StringUtil.toLowerCase((String)options2.getMatchOptions().getFileType().getName());
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileType));
    }

    public boolean shouldShowProblem(PsiErrorElement error) {
        return false;
    }

    public boolean canBeVarDelimiter(@NotNull PsiElement element) {
        return false;
    }

    public String getText(PsiElement match, int start, int end) {
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        String name;
        if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
            return name;
        }
        return element.getText();
    }

    public String getMeaningfulText(PsiElement element) {
        return this.getTypedVarString(element);
    }

    public String getAlternativeText(PsiElement element, String previousText) {
        return null;
    }

    public PsiElement updateCurrentNode(PsiElement node2) {
        return node2;
    }

    public PsiElement extendMatchedByDownUp(PsiElement node2) {
        return node2;
    }

    public PsiElement extendMatchOnePsiFile(PsiElement file2) {
        return file2;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    public Configuration[] getPredefinedTemplates() {
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node2, ReplaceOptions options2, ReplacementBuilder builder2) {
    }

    public void handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result2, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean removeSemicolon = false;
            if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (buf.length() > 0) {
                        if (info.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            PsiElement sibling = currentElement.getPrevSibling();
                            buf.append(sibling instanceof PsiWhiteSpace ? sibling.getText() : " ");
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    removeSemicolon = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else {
                if (info.isStatementContext()) {
                    removeSemicolon = match.getMatch() instanceof PsiComment;
                }
                replacementString = match.getMatchImage();
            }
            int offset = Replacer.insertSubstitution(result2, 0, info, replacementString);
            if (info.isStatementContext() && (removeSemicolon || StringUtil.endsWithChar((CharSequence)replacementString, (char)';') || StringUtil.endsWithChar((CharSequence)replacementString, (char)'}'))) {
                int start = info.getStartIndex() + offset;
                result2.delete(start, start + 1);
            }
        }
    }

    public void handleNoSubstitution(ParameterInfo info, StringBuilder result2) {
        if (info.isHasCommaBefore()) {
            result2.delete(info.getBeforeDelimiterPos(), info.getBeforeDelimiterPos() + 1);
        } else if (info.isHasCommaAfter()) {
            result2.delete(info.getAfterDelimiterPos(), info.getAfterDelimiterPos() + 1);
        }
    }

    @Contract(value="null -> false")
    public boolean isIdentifier(@Nullable PsiElement element) {
        return false;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        return Collections.emptySet();
    }

    public boolean isDocCommentOwner(PsiElement match) {
        return false;
    }

    @Contract(value="!null -> !null")
    public PsiElement getPresentableElement(PsiElement element) {
        return this.isIdentifier(element) ? element.getParent() : element;
    }

    public boolean isApplicableConstraint(String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        switch (constraintName) {
            case "MINIMUM ZERO": {
                if (target) {
                    return false;
                }
            }
            case "MAXIMUM UNLIMITED": 
            case "TEXT": 
            case "REFERENCE": {
                return !completePattern;
            }
        }
        return false;
    }

    public final boolean isApplicableConstraint(String constraintName, List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (nodes.isEmpty()) {
            return this.isApplicableConstraint(constraintName, (PsiElement)null, completePattern, target);
        }
        boolean result2 = true;
        for (PsiElement psiElement : nodes) {
            result2 &= this.isApplicableConstraint(constraintName, psiElement, completePattern, target);
        }
        return result2;
    }

    public boolean isApplicableContextConfiguration(@NotNull Configuration configuration) {
        return !configuration.isPredefined();
    }
}

