/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.mock;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetType;
import com.intellij.facet.mock.MockFacetConfiguration;
import com.intellij.facet.mock.MockFacetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MockFacet
extends Facet<MockFacetConfiguration>
implements FacetRootsProvider {
    private boolean myInitialized;
    private boolean myDisposed;
    private boolean myConfigured;

    public MockFacet(@NotNull Module module2, String name) {
        this(module2, name, new MockFacetConfiguration());
    }

    public MockFacet(Module module2, String name, MockFacetConfiguration configuration) {
        super((FacetType)MockFacetType.getInstance(), module2, name, (FacetConfiguration)configuration, null);
    }

    public void initFacet() {
        this.myInitialized = true;
    }

    public void disposeFacet() {
        this.myDisposed = true;
    }

    public boolean isConfigured() {
        return this.myConfigured;
    }

    public void configure() {
        this.myConfigured = true;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void addRoot(VirtualFile root) {
        ((MockFacetConfiguration)this.getConfiguration()).addRoot(root);
        this.fireFacetChangedEvent();
    }

    private void fireFacetChangedEvent() {
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    public void removeRoot(VirtualFile root) {
        ((MockFacetConfiguration)this.getConfiguration()).removeRoot(root);
        this.fireFacetChangedEvent();
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        return ((MockFacetConfiguration)this.getConfiguration()).getRoots();
    }
}

