/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TracingData {
    private static final String tracingDataLocation = "E:\\ultimate\\system\\occurrences";
    private final PersistentHashMap<Integer, Integer> keys;
    private final ScheduledThreadPoolExecutor pool = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"My flushing thread");
    private final AtomicInteger maxHash = new AtomicInteger();
    private final AtomicInteger maxValue = new AtomicInteger();
    private ScheduledFuture<?> flushingFuture;

    TracingData() {
        PersistentHashMap<Integer, Integer> lkeys = null;
        try {
            lkeys = TracingData.createOrOpenMap();
            this.flushingFuture = this.pool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (TracingData.this.keys.isDirty() && !TracingData.this.keys.isClosed()) {
                        TracingData.this.keys.force();
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            ShutDownTracker.getInstance().registerShutdownTask(() -> this.flushingFuture.cancel(false));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.keys = lkeys;
    }

    private static PersistentHashMap<Integer, Integer> createOrOpenMap() throws IOException {
        return new PersistentHashMap(Paths.get(tracingDataLocation, new String[0]), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE);
    }

    public void record(int hash, int cost, PsiFragment frag) {
        if (this.keys != null) {
            try {
                Integer integer = (Integer)this.keys.get((Object)hash);
                int value = integer != null ? integer + 1 : 1;
                this.keys.put((Object)hash, (Object)value);
                int currentMaxValue = this.maxValue.get();
                while (value > currentMaxValue) {
                    if (this.maxValue.compareAndSet(currentMaxValue, value)) {
                        this.maxHash.set(hash);
                        System.out.println(this.maxValue + "," + this.maxHash + "," + frag.getElements()[0].getText());
                        break;
                    }
                    currentMaxValue = this.maxValue.get();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        PersistentHashMap<Integer, Integer> lKeys = TracingData.createOrOpenMap();
        IntArrayList mapping = new IntArrayList();
        lKeys.processKeysWithExistingMapping((Processor)new CommonProcessors.CollectProcessor((Collection)mapping));
        System.out.println(mapping.size());
        Int2IntOpenHashMap map2 = new Int2IntOpenHashMap(mapping.size());
        IntListIterator iterator2 = mapping.iterator();
        while (iterator2.hasNext()) {
            int i2 = iterator2.nextInt();
            map2.put(i2, ((Integer)lKeys.get((Object)i2)).intValue());
        }
        mapping.sort((o1, o2) -> map2.get(o2) - map2.get(o1));
        for (int i3 = 0; i3 < 500; ++i3) {
            System.out.println(mapping.getInt(i3) + ":" + map2.get(mapping.getInt(i3)));
        }
        lKeys.close();
    }
}

