/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DuplicatesProfile {
    public static final ExtensionPointName<DuplicatesProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.duplicates.profile");
    private static final int FACTOR = 2;
    private static final int MAX_COST = 7000;

    @NotNull
    public abstract DuplocateVisitor createVisitor(@NotNull FragmentsCollector var1);

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        return this.createVisitor(collector);
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public abstract DuplocatorState getDuplocatorState(@NotNull Language var1);

    @Nullable
    public String getComment(@NotNull DupInfo info, int index) {
        return null;
    }

    public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
        PsiFragment[] fragments = info.getFragmentOccurences(index);
        Language language = fragments.length > 0 ? fragments[0].getLanguage() : null;
        return language != null && this.isMyLanguage(language);
    }

    public boolean supportIndex() {
        return true;
    }

    public boolean supportDuplicatesIndex() {
        return false;
    }

    public boolean acceptsContentForIndexing(FileContent fileContent) {
        return true;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        int lowerBound = state.getLowerBound();
        return cost >= 2 * lowerBound && cost <= 7000;
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(@NotNull Language language) {
        return DuplicatesProfile.findProfileForLanguage(EP_NAME.getExtensionList(), language);
    }

    @NotNull
    public static List<DuplicatesProfile> getAllProfiles() {
        return EP_NAME.getExtensionList();
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(List<? extends DuplicatesProfile> profiles, @NotNull Language language) {
        for (DuplicatesProfile duplicatesProfile : profiles) {
            if (!duplicatesProfile.isMyLanguage(language)) continue;
            return duplicatesProfile;
        }
        return null;
    }

    @Nullable
    public static DuplicatesProfile findProfileForDuplicate(@NotNull DupInfo dupInfo, int index) {
        for (DuplicatesProfile profile : EP_NAME.getExtensionList()) {
            if (!profile.isMyDuplicate(dupInfo, index)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        return element.getLanguage();
    }

    @Nullable
    public PsiElementRole getRole(@NotNull PsiElement element) {
        return null;
    }
}

