/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import org.junit.runner.Describable;
import org.junit.runner.Description;

public class TestDiscoveryBasicListener
implements TestListener {
    public void addError(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
    }

    public void endTest(Test test) {
        String className = TestDiscoveryBasicListener.getClassName(test);
        String methodName = TestDiscoveryBasicListener.getMethodName(test);
        try {
            Object data = this.getData();
            Method testEnded = data.getClass().getMethod("testDiscoveryEnded", String.class, String.class);
            testEnded.invoke(data, className, methodName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startTest(Test test) {
        try {
            Object data = this.getData();
            Method testStarted = data.getClass().getMethod("testDiscoveryStarted", String.class, String.class);
            testStarted.invoke(data, TestDiscoveryBasicListener.getClassName(test), TestDiscoveryBasicListener.getMethodName(test));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected Object getData() throws Exception {
        return Class.forName("com.intellij.rt.coverage.data.TestDiscoveryProjectData").getMethod("getProjectData", ArrayUtil.EMPTY_CLASS_ARRAY).invoke(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    private static String getMethodName(Test test) {
        Description description2;
        String name;
        String name2;
        if (test instanceof TestCase && (name2 = ((TestCase)test).getName()) != null) {
            return name2;
        }
        if (test instanceof Describable && (name = TestDiscoveryBasicListener.getMethodName(description2 = ((Describable)test).getDescription())) != null) {
            return name;
        }
        String toString = test.toString();
        int braceIdx = toString.indexOf("(");
        return braceIdx > 0 ? toString.substring(0, braceIdx) : toString;
    }

    private static String getClassName(Test test) {
        Description description2;
        String name;
        if (test instanceof Describable && (name = TestDiscoveryBasicListener.getClassName(description2 = ((Describable)test).getDescription())) != null) {
            return name;
        }
        return test.getClass().getName();
    }

    public static String getClassName(Description description2) {
        try {
            return description2.getClassName();
        }
        catch (NoSuchMethodError e) {
            String displayName2 = description2.getDisplayName();
            Matcher matcher = Pattern.compile("(.*)\\((.*)\\)").matcher(displayName2);
            return matcher.matches() ? matcher.group(2) : displayName2;
        }
    }

    public static String getMethodName(Description description2) {
        try {
            return description2.getMethodName();
        }
        catch (NoSuchMethodError e) {
            String displayName2 = description2.getDisplayName();
            Matcher matcher = Pattern.compile("(.*)\\((.*)\\)").matcher(displayName2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }
    }
}

