/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomFileIndex;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import com.intellij.util.xml.stubs.FileStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomServiceImpl
extends DomService {
    @NotNull
    private static XmlFileHeader calcXmlFileHeader(XmlFile file) {
        Stub root;
        ObjectStubTree tree;
        VirtualFile virtualFile;
        if (file instanceof PsiFileEx && ((PsiFileEx)file).isContentsLoaded() && file.getNode().isParsed()) {
            return DomServiceImpl.computeHeaderByPsi(file);
        }
        if (FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && file.getFileType() == XmlFileType.INSTANCE && (virtualFile = file.getVirtualFile()) instanceof VirtualFileWithId && (tree = StubTreeLoader.getInstance().readFromVFile(file.getProject(), virtualFile)) != null && (root = tree.getRoot()) instanceof FileStub) {
            return ((FileStub)root).getHeader();
        }
        if (!file.isValid()) {
            return XmlFileHeader.EMPTY;
        }
        XmlFileHeader header = NanoXmlUtil.parseHeader((PsiFile)file);
        if (header.getRootTagLocalName() == null) {
            return DomServiceImpl.computeHeaderByPsi(file);
        }
        return header;
    }

    private static XmlFileHeader computeHeaderByPsi(XmlFile file) {
        XmlTag tag;
        XmlDoctype doctype;
        XmlDocument document = file.getDocument();
        if (document == null) {
            return XmlFileHeader.EMPTY;
        }
        String publicId = null;
        String systemId = null;
        XmlProlog prolog = document.getProlog();
        if (prolog != null && (doctype = prolog.getDoctype()) != null) {
            publicId = doctype.getPublicId();
            systemId = doctype.getSystemId();
            if (systemId == null) {
                systemId = doctype.getDtdUri();
            }
        }
        if ((tag = document.getRootTag()) == null) {
            return XmlFileHeader.EMPTY;
        }
        String localName = tag.getLocalName();
        if (StringUtil.isNotEmpty((String)localName)) {
            if (tag.getPrevSibling() instanceof PsiErrorElement) {
                return XmlFileHeader.EMPTY;
            }
            String psiNs = (String)tag.getLocalNamespaceDeclarations().get(tag.getNamespacePrefix());
            return new XmlFileHeader(localName, psiNs, publicId, systemId);
        }
        return XmlFileHeader.EMPTY;
    }

    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    public <T extends DomElement> DomAnchor<T> createAnchor(T domElement) {
        return DomAnchorImpl.createAnchor(domElement);
    }

    @NotNull
    public XmlFile getContainingFile(@NotNull DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        return DomManagerImpl.getNotNullHandler(domElement).getFile();
    }

    @NotNull
    public EvaluatedXmlName getEvaluatedXmlName(@NotNull DomElement element) {
        return DomManagerImpl.getNotNullHandler(element).getXmlName();
    }

    @NotNull
    public XmlFileHeader getXmlFileHeader(XmlFile file) {
        if (FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null) {
            return DomServiceImpl.calcXmlFileHeader(file);
        }
        return (XmlFileHeader)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)DomServiceImpl.calcXmlFileHeader(file), new Object[]{file}));
    }

    public Collection<VirtualFile> getDomFileCandidates(Class<? extends DomElement> rootElementClass, Project project, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(DomFileIndex.NAME, (Object)rootElementClass.getName(), scope);
    }

    public <T extends DomElement> List<DomFileElement<T>> getFileElements(Class<T> clazz, Project project, @Nullable GlobalSearchScope scope) {
        Collection<VirtualFile> list = this.getDomFileCandidates(clazz, project, scope != null ? scope : GlobalSearchScope.allScope((Project)project));
        ArrayList<DomFileElement<T>> result = new ArrayList<DomFileElement<T>>(list.size());
        for (VirtualFile file : list) {
            DomFileElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof XmlFile) || (element = DomManager.getDomManager((Project)project).getFileElement((XmlFile)psiFile, clazz)) == null) continue;
            result.add(element);
        }
        return result;
    }

    public StructureViewBuilder createSimpleStructureViewBuilder(XmlFile file, Function<DomElement, DomService.StructureViewMode> modeProvider) {
        return new DomStructureViewBuilder(file, modeProvider);
    }
}

