/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.lib.InterpreterFactory;
import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.TraceResultInterpreter;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.TracingResultImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.LongValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TraceResultInterpreterImpl
implements TraceResultInterpreter {
    private static final Logger LOG = Logger.getInstance(TraceResultInterpreterImpl.class);
    private final InterpreterFactory myInterpreterFactory;

    public TraceResultInterpreterImpl(@NotNull InterpreterFactory interpreterFactory2) {
        this.myInterpreterFactory = interpreterFactory2;
    }

    @Override
    @NotNull
    public TracingResult interpret(@NotNull StreamChain chain, @NotNull ArrayReference resultArray) {
        ArrayReference info = (ArrayReference)resultArray.getValue(0);
        ArrayReference result = (ArrayReference)resultArray.getValue(1);
        Value streamResult2 = result.getValue(0);
        Value time = resultArray.getValue(2);
        TraceResultInterpreterImpl.logTime(time);
        List<TraceInfo> trace = this.getTrace(chain, info);
        return new TracingResultImpl(chain, TraceElementImpl.ofResultValue(streamResult2), trace, TraceResultInterpreterImpl.isException(result));
    }

    @NotNull
    private List<TraceInfo> getTrace(@NotNull StreamChain chain, @NotNull ArrayReference info) {
        int callCount = chain.length();
        ArrayList<TraceInfo> result = new ArrayList<TraceInfo>(callCount);
        for (int i = 0; i < callCount; ++i) {
            StreamCall call2 = chain.getCall(i);
            Value trace = info.getValue(i);
            CallTraceInterpreter interpreter = this.myInterpreterFactory.getInterpreter(call2.getName());
            TraceInfo traceInfo = trace == null ? ValuesOrderInfo.empty(call2) : interpreter.resolve(call2, trace);
            result.add(traceInfo);
        }
        return result;
    }

    private static void logTime(@NotNull Value elapsedTimeArray) {
        Value elapsedTime = ((ArrayReference)elapsedTimeArray).getValue(0);
        long elapsedNanoseconds = ((LongValue)elapsedTime).value();
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(elapsedNanoseconds);
        LOG.info("evaluation completed in " + elapsedMillis + "ms");
    }

    private static boolean isException(@NotNull ArrayReference result) {
        ReferenceType type = result.referenceType();
        return type instanceof ArrayType && ((ArrayType)type).componentTypeName().contains("Throwable");
    }
}

