/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FilterResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        assert (before.size() >= after.size());
        LinkedHashMap<TraceElement, List<TraceElement>> forward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        LinkedHashMap<TraceElement, List<TraceElement>> backward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        int[] beforeTimes = before.keySet().stream().mapToInt(Integer::intValue).sorted().toArray();
        int[] afterTimes = after.keySet().stream().mapToInt(Integer::intValue).sorted().toArray();
        int beforeIndex = 0;
        block0: for (int afterTime : afterTimes) {
            TraceElement afterElement = after.get(afterTime);
            Value afterValue = afterElement.getValue();
            while (beforeIndex < beforeTimes.length) {
                TraceElement beforeElement = before.get(beforeTimes[beforeIndex]);
                if (Objects.equals(beforeElement.getValue(), afterValue)) {
                    forward.put(beforeElement, Collections.singletonList(afterElement));
                    backward.put(afterElement, Collections.singletonList(beforeElement));
                    ++beforeIndex;
                    continue block0;
                }
                forward.put(beforeElement, Collections.emptyList());
                ++beforeIndex;
            }
        }
        while (beforeIndex < beforeTimes.length) {
            int beforeTime = beforeTimes[beforeIndex];
            forward.put(before.get(beforeTime), Collections.emptyList());
            ++beforeIndex;
        }
        return ValuesOrderResolver.Result.of(forward, backward);
    }
}

