/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWhileLoopWithDoWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new WhileLoopPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiStatement body2 = whileStatement.getBody();
        PsiExpression condition2 = whileStatement.getCondition();
        boolean infiniteLoop = BoolUtils.isTrue(condition2);
        StringBuilder doWhileStatementText = new StringBuilder();
        CommentTracker tracker = new CommentTracker();
        if (!infiniteLoop) {
            doWhileStatementText.append("if(");
            if (condition2 != null) {
                doWhileStatementText.append(tracker.text((PsiElement)condition2));
            }
            doWhileStatementText.append(") {\n");
        }
        if (body2 instanceof PsiBlockStatement) {
            doWhileStatementText.append("do {");
            PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    doWhileStatementText.append(tracker.text(child));
                }
            }
            doWhileStatementText.append('}');
        } else if (body2 != null) {
            doWhileStatementText.append("do ").append(tracker.text((PsiElement)body2)).append('\n');
        }
        doWhileStatementText.append("while(");
        if (condition2 != null) {
            doWhileStatementText.append(tracker.text((PsiElement)condition2));
        }
        doWhileStatementText.append(");");
        if (!infiniteLoop) {
            doWhileStatementText.append("\n}");
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)whileStatement, doWhileStatementText.toString(), tracker);
    }
}

