/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ExtractWhileLoopConditionToIfStatementIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        WhileLoopPredicate predicate = new WhileLoopPredicate();
        return e -> predicate.satisfiedBy(e) && !ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiWhileStatement)e.getParent()).getCondition()), Boolean.TRUE);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiElement newElement;
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiExpression condition2 = whileStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        Project project = whileStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        condition2.replace((PsiElement)factory.createExpressionFromText("true", (PsiElement)whileStatement));
        PsiStatement body2 = whileStatement.getBody();
        PsiStatement ifStatement = factory.createStatementFromText("if (" + conditionText + ") break;", (PsiElement)whileStatement);
        if (body2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            newElement = codeBlock.addBefore((PsiElement)ifStatement, codeBlock.getFirstBodyElement());
        } else if (body2 != null) {
            PsiStatement newStatement = BlockUtils.expandSingleStatementToBlockStatement(body2);
            newElement = newStatement.getParent().addBefore((PsiElement)ifStatement, (PsiElement)newStatement);
        } else {
            return;
        }
        CodeStyleManager.getInstance((Project)project).reformat(newElement);
    }
}

