/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.codeInsight.intention.numeric.AbstractNumberConversionIntention;
import com.intellij.codeInsight.intention.numeric.NumberConverter;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ipp.integer.JavaNumberConverters;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNumberConversionIntention
extends AbstractNumberConversionIntention {
    private static final ImmutableList<NumberConverter> JAVA_1_CONVERTERS = ContainerUtil.immutableList((Object[])new NumberConverter[]{JavaNumberConverters.INTEGER_TO_DECIMAL, JavaNumberConverters.INTEGER_TO_HEX, JavaNumberConverters.INTEGER_TO_OCTAL, JavaNumberConverters.FLOAT_TO_DECIMAL, JavaNumberConverters.FLOAT_TO_PLAIN, JavaNumberConverters.FLOAT_TO_SCIENTIFIC});
    private static final ImmutableList<NumberConverter> JAVA_5_CONVERTERS = ContainerUtil.immutableList((Object[])new NumberConverter[]{JavaNumberConverters.INTEGER_TO_DECIMAL, JavaNumberConverters.INTEGER_TO_HEX, JavaNumberConverters.INTEGER_TO_OCTAL, JavaNumberConverters.FLOAT_TO_DECIMAL, JavaNumberConverters.FLOAT_TO_PLAIN, JavaNumberConverters.FLOAT_TO_SCIENTIFIC, JavaNumberConverters.FLOAT_TO_HEX});
    private static final ImmutableList<NumberConverter> JAVA_7_CONVERTERS = ContainerUtil.immutableList((Object[])new NumberConverter[]{JavaNumberConverters.INTEGER_TO_DECIMAL, JavaNumberConverters.INTEGER_TO_HEX, JavaNumberConverters.INTEGER_TO_BINARY, JavaNumberConverters.INTEGER_TO_OCTAL, JavaNumberConverters.FLOAT_TO_DECIMAL, JavaNumberConverters.FLOAT_TO_PLAIN, JavaNumberConverters.FLOAT_TO_SCIENTIFIC, JavaNumberConverters.FLOAT_TO_HEX});

    @Nullable
    @Contract(pure=true)
    protected AbstractNumberConversionIntention.NumberConversionContext extract(@NotNull PsiElement element) {
        PsiLiteralExpression literal;
        if (element instanceof PsiJavaToken) {
            element = element.getParent();
        }
        if ((literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)element, PsiLiteralExpression.class)) == null) {
            return null;
        }
        Number value2 = (Number)ObjectUtils.tryCast((Object)literal.getValue(), Number.class);
        if (value2 == null) {
            return null;
        }
        if (ExpressionUtils.isNegative((PsiExpression)literal)) {
            value2 = Objects.requireNonNull(JavaPsiMathUtil.negate(value2));
            return new AbstractNumberConversionIntention.NumberConversionContext(element.getParent(), value2, literal.getText(), true);
        }
        return new AbstractNumberConversionIntention.NumberConversionContext(element, value2, literal.getText(), false);
    }

    @NotNull
    @Contract(pure=true)
    protected List<NumberConverter> getConverters(@NotNull PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return Collections.emptyList();
        }
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)file);
        if (level.isLessThan(LanguageLevel.JDK_1_5)) {
            return JAVA_1_CONVERTERS;
        }
        if (level.isLessThan(LanguageLevel.JDK_1_7)) {
            return JAVA_5_CONVERTERS;
        }
        return JAVA_7_CONVERTERS;
    }

    protected void replace(PsiElement sourceElement, String replacement) {
        new CommentTracker().replaceAndRestoreComments(sourceElement, replacement);
    }
}

