/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.collections;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableCollectionModelUtils {
    private static final CallMatcher MAP_ENTRY_CALL = CallMatcher.staticCall("java.util.Map", "entry").parameterCount(2);

    ImmutableCollectionModelUtils() {
    }

    @Nullable
    static ImmutableCollectionModel createModel(@NotNull PsiMethodCallExpression call) {
        CollectionType type2 = CollectionType.create(call);
        if (type2 == null) {
            return null;
        }
        if (!CodeBlockSurrounder.canSurround((PsiExpression)call)) {
            return null;
        }
        String assignedVariable = ImmutableCollectionModelUtils.getAssignedVariable(call);
        PsiExpression[] args = call.getArgumentList().getExpressions();
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)call.getType(), PsiClassType.class);
        if (classType == null) {
            return null;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)call.getProject()).getResolveHelper();
        boolean hasNonResolvedTypeParams = Arrays.stream(classType.getParameters()).map(PsiUtil::resolveClassInClassTypeOnly).anyMatch(aClass -> ImmutableCollectionModelUtils.isNonResolvedTypeParameter(aClass, (PsiElement)call, resolveHelper));
        if (hasNonResolvedTypeParams) {
            return null;
        }
        if ("ofEntries".equals(method.getName()) && Arrays.stream(args).anyMatch(arg -> ImmutableCollectionModelUtils.extractPutArgs(arg) == null)) {
            return null;
        }
        return new ImmutableCollectionModel(call, type2, method, assignedVariable);
    }

    @Contract(value="null, _, _ -> false")
    private static boolean isNonResolvedTypeParameter(@Nullable PsiClass parameter2, @NotNull PsiElement context, @NotNull PsiResolveHelper resolveHelper) {
        if (!(parameter2 instanceof PsiTypeParameter)) {
            return false;
        }
        PsiTypeParameter typeParameter = (PsiTypeParameter)parameter2;
        String name2 = typeParameter.getName();
        return name2 == null || resolveHelper.resolveReferencedClass(name2, context) != parameter2;
    }

    static void replaceWithMutable(@NotNull ImmutableCollectionModel model, @Nullable Editor editor) {
        ToMutableCollectionConverter.convert(model, editor);
    }

    @Nullable
    private static String getAssignedVariable(@NotNull PsiMethodCallExpression call) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{PsiVariable.class, PsiAssignmentExpression.class});
        if (parent == null) {
            return null;
        }
        if (parent instanceof PsiVariable) {
            PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)parent).getInitializer());
            return initializer == call ? ((PsiVariable)parent).getName() : null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
        if (rhs != call) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)lhs, PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null && SideEffectChecker.mayHaveSideEffects(qualifier)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
        if (variable == null || variable instanceof PsiField && variable.hasModifierProperty("volatile")) {
            return null;
        }
        return ref.getText();
    }

    @Nullable
    private static String extractPutArgs(@NotNull PsiExpression entryExpression) {
        if (entryExpression instanceof PsiReferenceExpression) {
            return MessageFormat.format("{0}.getKey(), {0}.getValue()", entryExpression.getText());
        }
        PsiCallExpression call = (PsiCallExpression)ObjectUtils.tryCast((Object)entryExpression, PsiCallExpression.class);
        if (call == null || !ImmutableCollectionModelUtils.isEntryConstruction(call)) {
            return null;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length == 1) {
            return ImmutableCollectionModelUtils.extractPutArgs(expressions2[0]);
        }
        if (expressions2.length == 2) {
            return expressions2[0].getText() + "," + expressions2[1].getText();
        }
        return null;
    }

    private static boolean isEntryConstruction(@NotNull PsiCallExpression call) {
        if (MAP_ENTRY_CALL.matches((PsiExpression)call)) {
            return true;
        }
        PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)call, PsiNewExpression.class);
        return newExpression != null && InheritanceUtil.isInheritor((PsiType)newExpression.getType(), (String)"java.util.Map.Entry");
    }

    private static class VariableRenamer
    extends VariableInplaceRenamer {
        private final PsiElement myAnchor;

        private VariableRenamer(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull PsiElement anchor) {
            super(elementToRename, editor);
            this.myAnchor = anchor;
            editor.getCaretModel().moveToOffset(elementToRename.getTextOffset());
        }

        public void finish(boolean success) {
            super.finish(success);
            this.myEditor.getCaretModel().moveToOffset(this.myAnchor.getTextRange().getEndOffset());
        }

        static void rename(@NotNull PsiNamedElement elementToRename, String @NotNull [] names2, @NotNull Editor editor, @NotNull PsiElement anchor) {
            PsiDocumentManager.getInstance((Project)elementToRename.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            LinkedHashSet<String> suggestions = new LinkedHashSet<String>(Arrays.asList(names2));
            new VariableRenamer(elementToRename, editor, anchor).performInplaceRefactoring(suggestions);
        }
    }

    static class ImmutableCollectionModel {
        private PsiMethodCallExpression myCall;
        private final CollectionType myType;
        private final boolean myIsVarArgCall;
        private final PsiExpression[] myArgs;
        private final String myAssignedVariable;

        @Contract(pure=true)
        ImmutableCollectionModel(@NotNull PsiMethodCallExpression call, @NotNull CollectionType type2, @NotNull PsiMethod method, @Nullable String assignedVariable) {
            this.myCall = call;
            this.myType = type2;
            this.myIsVarArgCall = !method.isVarArgs() || MethodCallUtils.isVarArgCall((PsiCall)call);
            this.myArgs = call.getArgumentList().getExpressions();
            this.myAssignedVariable = assignedVariable;
        }
    }

    private static class ToMutableCollectionConverter {
        private final PsiElementFactory myElementFactory;
        private final JavaCodeStyleManager myCodeStyleManager;
        private final Editor myEditor;

        private ToMutableCollectionConverter(@NotNull Project project, @Nullable Editor editor) {
            this.myElementFactory = PsiElementFactory.getInstance((Project)project);
            this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            this.myEditor = editor;
        }

        private void replaceWithMutable(@NotNull ImmutableCollectionModel model) {
            CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)model.myCall);
            if (surrounder == null) {
                return;
            }
            CodeBlockSurrounder.SurroundResult result = surrounder.surround();
            PsiMethodCallExpression call = (PsiMethodCallExpression)result.getExpression();
            PsiStatement statement = result.getAnchor();
            model.myCall = call;
            String assignedVariable = model.myAssignedVariable;
            if (assignedVariable != null) {
                String initializerText = model.myType.getInitializerText(model.myIsVarArgCall ? null : call.getText());
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, initializerText, new CommentTracker());
                PsiStatement anchor = this.addUpdates(assignedVariable, model, statement);
                if (this.myEditor != null) {
                    this.myEditor.getCaretModel().moveToOffset(anchor.getTextRange().getEndOffset());
                }
            } else {
                this.createVariable(statement, model);
            }
        }

        private void createVariable(@NotNull PsiStatement statement, @NotNull ImmutableCollectionModel model) {
            PsiMethodCallExpression call = model.myCall;
            PsiType type2 = call.getType();
            if (type2 == null) {
                return;
            }
            String[] names2 = this.getNameSuggestions(call, type2);
            if (names2.length == 0) {
                return;
            }
            String name2 = names2[0];
            PsiDeclarationStatement declaration2 = this.createDeclaration(name2, type2, model, statement);
            if (declaration2 == null) {
                return;
            }
            PsiVariable declaredVariable = (PsiVariable)declaration2.getDeclaredElements()[0];
            PsiStatement anchor = this.addUpdates(name2, model, (PsiStatement)declaration2);
            if (call.getParent() instanceof PsiExpressionStatement) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)call, name2, new CommentTracker());
            }
            if (this.myEditor != null) {
                VariableRenamer.rename((PsiNamedElement)declaredVariable, names2, this.myEditor, (PsiElement)anchor);
            }
        }

        @Nullable
        private PsiDeclarationStatement createDeclaration(@NotNull String name2, @NotNull PsiType type2, @NotNull ImmutableCollectionModel model, @NotNull PsiStatement usage) {
            String initializerText = model.myType.getInitializerText(model.myIsVarArgCall ? null : model.myCall.getText());
            PsiExpression initializer = this.myElementFactory.createExpressionFromText(initializerText, null);
            PsiType rhsType = initializer.getType();
            if (rhsType == null) {
                return null;
            }
            if (!TypeUtils.areConvertible(type2, rhsType)) {
                type2 = ExpectedTypeUtils.findExpectedType((PsiExpression)model.myCall, false);
            }
            if (type2 == null) {
                return null;
            }
            PsiDeclarationStatement declaration2 = this.myElementFactory.createVariableDeclarationStatement(name2, type2, initializer);
            return (PsiDeclarationStatement)ObjectUtils.tryCast((Object)BlockUtils.addBefore(usage, new PsiStatement[]{declaration2}), PsiDeclarationStatement.class);
        }

        private String @NotNull [] getNameSuggestions(@NotNull PsiMethodCallExpression call, @NotNull PsiType type2) {
            String propertyName = this.getPropertyName(call, type2);
            SuggestedNameInfo nameInfo = this.myCodeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, propertyName, (PsiExpression)call, type2);
            return this.myCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)nameInfo, (PsiElement)call, (boolean)true).names;
        }

        @NotNull
        private String getPropertyName(@NotNull PsiMethodCallExpression call, @NotNull PsiType type2) {
            String propertyName = ToMutableCollectionConverter.getPropertyNameByCall(call);
            if (propertyName != null) {
                return propertyName;
            }
            return this.myCodeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)type2).names[0];
        }

        @NotNull
        private PsiStatement addUpdates(@NotNull String variable, @NotNull ImmutableCollectionModel model, @NotNull PsiStatement anchor) {
            if (!model.myIsVarArgCall) {
                return anchor;
            }
            return (PsiStatement)StreamEx.of(ToMutableCollectionConverter.createUpdates(variable, model)).map(update2 -> this.myElementFactory.createStatementFromText(update2, null)).foldLeft((Object)anchor, (acc, update2) -> BlockUtils.addAfter(acc, update2));
        }

        @NotNull
        private static List<String> createUpdates(@NotNull String name2, @NotNull ImmutableCollectionModel model) {
            boolean isMapOfEntriesCall = "ofEntries".equals(model.myCall.getMethodExpression().getReferenceName());
            ArrayList<String> updates = new ArrayList<String>();
            PsiExpression[] args = model.myArgs;
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                if (model.myType != CollectionType.MAP) {
                    updates.add(String.format("%s.add(%s);", name2, arg.getText()));
                    continue;
                }
                if (isMapOfEntriesCall) {
                    updates.add(String.format("%s.put(%s);", name2, ImmutableCollectionModelUtils.extractPutArgs(arg)));
                    continue;
                }
                if (i % 2 == 0) continue;
                updates.add(String.format("%s.put(%s, %s);", name2, args[i - 1].getText(), arg.getText()));
            }
            return updates;
        }

        @Nullable
        private static String getPropertyNameByCall(@NotNull PsiMethodCallExpression call) {
            PsiMethodCallExpression outerCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class);
            if (outerCall == null) {
                return null;
            }
            PsiMethod method = outerCall.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiExpression[] arguments = outerCall.getArgumentList().getExpressions();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] != call) continue;
                int idx = i >= parameters2.length ? parameters2.length - 1 : i;
                return parameters2[idx].getName();
            }
            return null;
        }

        static void convert(@NotNull ImmutableCollectionModel model, @Nullable Editor editor) {
            new ToMutableCollectionConverter(model.myCall.getProject(), editor).replaceWithMutable(model);
        }
    }

    private static enum CollectionType {
        MAP("java.util.HashMap"),
        LIST("java.util.ArrayList"),
        SET("java.util.HashSet");

        private final String myMutableClass;
        private static final CallMapper<CollectionType> MAPPER;

        private CollectionType(String className2) {
            this.myMutableClass = className2;
        }

        @NotNull
        String getInitializerText(@Nullable String copyFrom) {
            return String.format("new " + this.myMutableClass + "<>(%s)", StringUtil.notNullize((String)copyFrom));
        }

        @Nullable
        static CollectionType create(@NotNull PsiMethodCallExpression call) {
            CollectionType type2 = MAPPER.mapFirst(call);
            if (type2 == null) {
                return null;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)call, false);
            if (expectedType == null) {
                return null;
            }
            PsiClassType newType = TypeUtils.getType(type2.myMutableClass, (PsiElement)call);
            return expectedType.isAssignableFrom((PsiType)newType) ? type2 : null;
        }

        static {
            MAPPER = new CallMapper<CollectionType>().register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptyMap").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "singletonMap").parameterCount(2), CallMatcher.staticCall("java.util.Map", "of"), CallMatcher.staticCall("java.util.Map", "ofEntries"), CallMatcher.staticCall("com.google.common.collect.ImmutableMap", "of")), MAP).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptyList").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "singletonList").parameterCount(1), CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("com.google.common.collect.ImmutableList", "of")), LIST).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptySet").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "singleton").parameterCount(1), CallMatcher.staticCall("java.util.Set", "of"), CallMatcher.staticCall("com.google.common.collect.ImmutableSet", "of")), SET);
        }
    }
}

