/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMayBeSynchronizedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.may.be.synchronized.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MethodMayBeSynchronizedQuickFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodMayBeSynchronizedVisitor();
    }

    private static class MethodMayBeSynchronizedVisitor
    extends BaseInspectionVisitor {
        private MethodMayBeSynchronizedVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            PsiElement parent = statement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)grandParent;
            if (!ControlFlowUtils.hasStatementCount(method.getBody(), 1)) {
                return;
            }
            PsiExpression lockExpression2 = statement.getLockExpression();
            if (method.hasModifierProperty("static")) {
                PsiClass containingClass;
                if (!(lockExpression2 instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classExpression = (PsiClassObjectAccessExpression)lockExpression2;
                PsiTypeElement typeElement = classExpression.getOperand();
                PsiType type2 = typeElement.getType();
                if (!(type2 instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type2;
                PsiClass aClass = classType.resolve();
                if (aClass != (containingClass = method.getContainingClass())) {
                    return;
                }
                this.registerMethodError(method, new Object[0]);
            } else {
                if (!(lockExpression2 instanceof PsiThisExpression)) {
                    return;
                }
                PsiThisExpression thisExpression = (PsiThisExpression)lockExpression2;
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                if (qualifier != null) {
                    PsiElement target = qualifier.resolve();
                    PsiClass containingClass = method.getContainingClass();
                    if (!containingClass.equals(target)) {
                        return;
                    }
                }
                this.registerMethodError(method, new Object[0]);
            }
        }
    }

    private static class MethodMayBeSynchronizedQuickFix
    extends InspectionGadgetsFix {
        private MethodMayBeSynchronizedQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("method.may.be.synchronized.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement identifier = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)identifier.getParent();
            PsiCodeBlock methodBody2 = method.getBody();
            PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(methodBody2);
            if (!(statement instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body2 = synchronizedStatement.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            if (statements.length > 0) {
                PsiElement added = methodBody2.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)synchronizedStatement);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat(added);
            }
            synchronizedStatement.delete();
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("synchronized", true);
        }
    }
}

