/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class BusyWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("busy.wait.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BusyWaitVisitor();
    }

    private static class BusyWaitVisitor
    extends BaseInspectionVisitor {
        private BusyWaitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiExpression loopCondition;
            PsiConditionalLoopStatement loopStatement;
            PsiStatement body2;
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, "java.lang.Thread", (PsiType)PsiType.VOID, "sleep", new PsiType[]{PsiType.LONG}) && !MethodCallUtils.isCallToMethod(expression2, "java.lang.Thread", (PsiType)PsiType.VOID, "sleep", new PsiType[]{PsiType.LONG, PsiType.INT})) {
                return;
            }
            PsiMethodCallExpression context = expression2;
            do {
                if ((loopStatement = (PsiConditionalLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiConditionalLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) == null) {
                    return;
                }
                context = loopStatement;
            } while (!PsiTreeUtil.isAncestor((PsiElement)(body2 = loopStatement.getBody()), (PsiElement)expression2, (boolean)true) || BusyWaitVisitor.isLocallyBoundLoop(loopCondition = loopStatement.getCondition()));
            this.registerMethodCallError(expression2, new Object[0]);
        }

        public static boolean isLocallyBoundLoop(PsiExpression loopCondition) {
            if ((loopCondition = PsiUtil.skipParenthesizedExprDown((PsiExpression)loopCondition)) == null) {
                return false;
            }
            if (ExpressionUtils.computeConstantExpression(loopCondition) == null && ExpressionUtils.isLocallyDefinedExpression(loopCondition)) {
                return true;
            }
            if (loopCondition instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)loopCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) {
                for (PsiExpression operand2 : ((PsiPolyadicExpression)loopCondition).getOperands()) {
                    if (!BusyWaitVisitor.isCounterCondition(operand2)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isCounterCondition(PsiExpression expr2) {
            PsiElement target;
            PsiReferenceExpression operand2;
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2), PsiBinaryExpression.class);
            if (binOp == null) {
                return false;
            }
            if (!ComparisonUtils.isComparisonOperation(binOp.getOperationTokenType())) {
                return false;
            }
            PsiExpression compared = null;
            if (PsiUtil.isConstantExpression((PsiExpression)binOp.getLOperand())) {
                compared = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            } else if (PsiUtil.isConstantExpression((PsiExpression)binOp.getROperand())) {
                compared = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            }
            if (compared == null) {
                return false;
            }
            return compared instanceof PsiUnaryExpression && (operand2 = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiUnaryExpression)compared).getOperand()), PsiReferenceExpression.class)) != null && PsiUtil.isAccessedForWriting((PsiExpression)operand2) && operand2.getQualifierExpression() == null && ((target = operand2.resolve()) instanceof PsiLocalVariable || target instanceof PsiParameter);
        }
    }
}

