/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MisorderedAssertEqualsArgumentsInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> methodNames = ContainerUtil.newHashSet((Object[])new String[]{"assertEquals", "assertEqualsNoOrder", "assertNotEquals", "assertArrayEquals", "assertSame", "assertNotSame", "failNotSame", "failNotEquals"});

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("misordered.assert.equals.arguments.problem.descriptor", new Object[0]);
    }

    @Override
    public final InspectionGadgetsFix buildFix(Object ... infos) {
        return new FlipArgumentsFix();
    }

    AssertHint createAssertHint(@NotNull PsiMethodCallExpression expression2) {
        return AssertHint.create(expression2, methodName -> methodNames.contains(methodName) ? Integer.valueOf(2) : null);
    }

    static boolean looksLikeExpectedArgument(PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        final Ref expectedArgument = Ref.create((Object)Boolean.TRUE);
        SmartList expressions2 = new SmartList();
        expressions2.add(expression2);
        while (!expressions2.isEmpty()) {
            ((PsiExpression)expressions2.remove(expressions2.size() - 1)).accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)expressions2){
                final /* synthetic */ List val$expressions;
                {
                    this.val$expressions = list;
                }

                public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                    if (!((Boolean)expectedArgument.get()).booleanValue()) {
                        return;
                    }
                    super.visitReferenceExpression(referenceExpression);
                    PsiElement target = referenceExpression.resolve();
                    if (target instanceof PsiEnumConstant || target instanceof PsiClass) {
                        return;
                    }
                    if (target instanceof PsiField) {
                        PsiField field = (PsiField)target;
                        if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                            return;
                        }
                    } else {
                        if (target instanceof PsiParameter) {
                            PsiParameter parameter2 = (PsiParameter)target;
                            if ("expected".equals(parameter2.getName())) {
                                return;
                            }
                            expectedArgument.set((Object)Boolean.FALSE);
                            return;
                        }
                        if (target instanceof PsiLocalVariable) {
                            PsiLocalVariable variable = (PsiLocalVariable)target;
                            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
                            if (block == null) {
                                return;
                            }
                            PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, (PsiVariable)variable);
                            if (definition == null) {
                                expectedArgument.set((Object)Boolean.FALSE);
                                return;
                            }
                            if (PsiUtil.isConstantExpression((PsiExpression)definition) || PsiType.NULL.equals((Object)definition.getType())) {
                                return;
                            }
                            PsiElement[] refs = DefUseUtil.getRefs(block, (PsiVariable)variable, (PsiElement)definition);
                            int offset = referenceExpression.getTextOffset();
                            for (PsiElement ref : refs) {
                                if (ref.getTextOffset() >= offset) continue;
                                expectedArgument.set((Object)Boolean.FALSE);
                                return;
                            }
                            this.val$expressions.add(definition);
                        }
                    }
                    if (!(target instanceof PsiCompiledElement)) {
                        expectedArgument.set((Object)Boolean.FALSE);
                    }
                }
            });
        }
        return (Boolean)expectedArgument.get();
    }

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new MisorderedAssertEqualsParametersVisitor();
    }

    private class MisorderedAssertEqualsParametersVisitor
    extends BaseInspectionVisitor {
        private MisorderedAssertEqualsParametersVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            AssertHint hint = MisorderedAssertEqualsArgumentsInspection.this.createAssertHint(expression2);
            if (hint == null) {
                return;
            }
            if (MisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(hint.getExpected()) || !MisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(hint.getActual())) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }

    private class FlipArgumentsFix
    extends InspectionGadgetsFix {
        private FlipArgumentsFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("misordered.assert.equals.arguments.flip.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (callExpression == null) {
                return;
            }
            AssertHint hint = MisorderedAssertEqualsArgumentsInspection.this.createAssertHint(callExpression);
            if (hint == null) {
                return;
            }
            PsiExpression expectedArgument = hint.getExpected();
            PsiExpression actualArgument = hint.getActual();
            PsiElement copy = expectedArgument.copy();
            expectedArgument.replace((PsiElement)actualArgument);
            actualArgument.replace(copy);
        }
    }
}

