/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConstantAssertArgumentInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> ASSERT_METHODS = new HashSet<String>();

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.junit.assert.argument.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantAssertArgumentVisitor();
    }

    static {
        ASSERT_METHODS.add("assertTrue");
        ASSERT_METHODS.add("assertFalse");
        ASSERT_METHODS.add("assertNull");
        ASSERT_METHODS.add("assertNotNull");
    }

    private static class ConstantAssertArgumentVisitor
    extends BaseInspectionVisitor {
        private ConstantAssertArgumentVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            AssertHint assertHint = AssertHint.create(expression2, methodName -> ASSERT_METHODS.contains(methodName) ? Integer.valueOf(1) : null);
            if (assertHint == null) {
                return;
            }
            PsiExpression argument = assertHint.getFirstArgument();
            if (!PsiUtil.isConstantExpression((PsiExpression)argument)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }
    }
}

