/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NotNull;

public class AssertWithoutMessageInspection
extends BaseInspection {
    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertionsWithoutMessagesVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("asserts.without.messages.problem.descriptor", new Object[0]);
    }

    private static class AssertionsWithoutMessagesVisitor
    extends BaseInspectionVisitor {
        private AssertionsWithoutMessagesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            AssertHint assertHint = AssertHint.create(expression2, methodName -> AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT.get(methodName));
            if (assertHint == null) {
                return;
            }
            PsiExpression message2 = assertHint.getMessage();
            if (message2 == null) {
                this.registerMethodCallError(expression2, new Object[0]);
            }
        }
    }
}

