/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissortedModifiersInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_requireAnnotationsFirst = true;
    public boolean typeUseWithType = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiModifierList modifierList = (PsiModifierList)infos[0];
        List<String> modifiers = MissortedModifiersInspection.getModifiers(modifierList);
        List<String> sortedModifiers = this.getSortedModifiers(modifierList);
        List<String> missortedModifiers = MissortedModifiersInspection.stripCommonPrefixSuffix(modifiers, sortedModifiers);
        return InspectionGadgetsBundle.message("missorted.modifiers.problem.descriptor", String.join((CharSequence)" ", missortedModifiers));
    }

    private static <E> List<E> stripCommonPrefixSuffix(List<E> list1, List<E> list2) {
        int max = list1.size() - MissortedModifiersInspection.commonSuffixLength(list1, list2);
        SmartList result = new SmartList();
        for (int i = 0; i < max; ++i) {
            E token = list1.get(i);
            if (token.equals(list2.get(i))) continue;
            result.add(token);
        }
        return result;
    }

    @Contract(pure=true)
    private static <E> int commonSuffixLength(@NotNull List<E> l1, @NotNull List<E> l2) {
        int i;
        int size1 = l1.size();
        int size2 = l2.size();
        if (size1 == 0 || size2 == 0) {
            return 0;
        }
        for (i = 0; i < size1 && i < size2 && l1.get(size1 - i - 1).equals(l2.get(size2 - i - 1)); ++i) {
        }
        return i;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissortedModifiersVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SortModifiersFix();
    }

    public void writeSettings(@NotNull Element node) {
        this.defaultWriteSettings(node, "typeUseWithType");
        this.writeBooleanOption(node, "typeUseWithType", false);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JCheckBox box = panel2.addCheckboxEx(InspectionGadgetsBundle.message("missorted.modifiers.require.option", new Object[0]), "m_requireAnnotationsFirst");
        panel2.addDependentCheckBox(InspectionGadgetsBundle.message("missorted.modifiers.typeuse.before.type.option", new Object[0]), "typeUseWithType", box);
        return panel2;
    }

    private static List<String> getModifiers(PsiModifierList modifierList) {
        return Stream.of(modifierList.getChildren()).filter(e -> e instanceof PsiJavaToken || e instanceof PsiAnnotation).map(PsiElement::getText).collect(Collectors.toList());
    }

    private List<String> getSortedModifiers(PsiModifierList modifierList) {
        SmartList modifiers = new SmartList();
        SmartList typeAnnotations = new SmartList();
        SmartList annotations = new SmartList();
        for (PsiElement child : modifierList.getChildren()) {
            if (child instanceof PsiJavaToken) {
                modifiers.add(child.getText());
                continue;
            }
            if (!(child instanceof PsiAnnotation)) continue;
            PsiAnnotation annotation = (PsiAnnotation)child;
            if (PsiImplUtil.isTypeAnnotation(child) && !MissortedModifiersInspection.isMethodWithVoidReturnType(modifierList.getParent())) {
                PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner());
                if (this.typeUseWithType || !modifiers.isEmpty() || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{targets[0]}) == PsiAnnotation.TargetType.UNKNOWN) {
                    typeAnnotations.add(child.getText());
                    continue;
                }
            }
            annotations.add(child.getText());
        }
        modifiers.sort(new ModifierComparator());
        SmartList result = new SmartList();
        result.addAll(annotations);
        result.addAll(modifiers);
        result.addAll(typeAnnotations);
        return result;
    }

    static boolean isMethodWithVoidReturnType(PsiElement element) {
        return element instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)element).getReturnType());
    }

    private static class ModifierComparator
    implements Comparator<String> {
        @NonNls
        private static final Map<String, Integer> s_modifierOrder = new HashMap<String, Integer>(12);

        private ModifierComparator() {
        }

        @Override
        public int compare(String modifier1, String modifier2) {
            Integer ordinal1 = s_modifierOrder.get(modifier1);
            Integer ordinal2 = s_modifierOrder.get(modifier2);
            return ordinal1 == null || ordinal2 == null ? 0 : ordinal1 - ordinal2;
        }

        static {
            s_modifierOrder.put("public", 0);
            s_modifierOrder.put("protected", 1);
            s_modifierOrder.put("private", 2);
            s_modifierOrder.put("abstract", 3);
            s_modifierOrder.put("default", 4);
            s_modifierOrder.put("static", 5);
            s_modifierOrder.put("final", 6);
            s_modifierOrder.put("transient", 7);
            s_modifierOrder.put("volatile", 8);
            s_modifierOrder.put("synchronized", 9);
            s_modifierOrder.put("native", 10);
            s_modifierOrder.put("strictfp", 11);
            s_modifierOrder.put("transitive", 12);
        }
    }

    private class MissortedModifiersVisitor
    extends BaseInspectionVisitor {
        private final Comparator<String> modifierComparator = new ModifierComparator();

        private MissortedModifiersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            super.visitClass(aClass);
            this.checkForMissortedModifiers((PsiModifierListOwner)aClass);
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            super.visitClassInitializer(initializer);
            this.checkForMissortedModifiers((PsiModifierListOwner)initializer);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            this.checkForMissortedModifiers((PsiModifierListOwner)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter2) {
            super.visitParameter(parameter2);
            this.checkForMissortedModifiers((PsiModifierListOwner)parameter2);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            this.checkForMissortedModifiers((PsiModifierListOwner)method);
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            this.checkForMissortedModifiers((PsiModifierListOwner)field);
        }

        public void visitRequiresStatement(PsiRequiresStatement statement) {
            super.visitRequiresStatement(statement);
            this.checkForMissortedModifiers((PsiModifierListOwner)statement);
        }

        private void checkForMissortedModifiers(PsiModifierListOwner listOwner) {
            PsiModifierList modifierList = listOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiElement modifier = this.getFirstMisorderedModifier(modifierList);
            if (modifier == null) {
                return;
            }
            this.registerError((PsiElement)(this.isVisibleHighlight((PsiElement)modifierList) ? modifier : modifierList), modifierList);
        }

        private PsiElement getFirstMisorderedModifier(PsiModifierList modifierList) {
            if (modifierList == null) {
                return null;
            }
            ArrayDeque<PsiElement> modifiers = new ArrayDeque<PsiElement>();
            PsiAnnotation typeAnnotation = null;
            for (PsiElement child : modifierList.getChildren()) {
                if (child instanceof PsiJavaToken) {
                    if (typeAnnotation != null) {
                        return typeAnnotation;
                    }
                    String text2 = child.getText();
                    if (!modifiers.isEmpty() && this.modifierComparator.compare(text2, ((PsiElement)modifiers.getLast()).getText()) < 0) {
                        while (!modifiers.isEmpty()) {
                            PsiElement first = (PsiElement)modifiers.pollFirst();
                            if (this.modifierComparator.compare(text2, first.getText()) >= 0) continue;
                            return first;
                        }
                    }
                    modifiers.add(child);
                }
                if (!(child instanceof PsiAnnotation)) continue;
                PsiAnnotation annotation = (PsiAnnotation)child;
                if (MissortedModifiersInspection.this.m_requireAnnotationsFirst) {
                    if (AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation) && !MissortedModifiersInspection.isMethodWithVoidReturnType(modifierList.getParent())) {
                        PsiAnnotation.TargetType[] targets;
                        if (MissortedModifiersInspection.this.typeUseWithType || !modifiers.isEmpty()) {
                            typeAnnotation = annotation;
                        }
                        if (AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{(targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner()))[0]}) != PsiAnnotation.TargetType.UNKNOWN) continue;
                        typeAnnotation = annotation;
                        continue;
                    }
                    if (!MissortedModifiersInspection.this.m_requireAnnotationsFirst || modifiers.isEmpty()) continue;
                    return (PsiElement)modifiers.getFirst();
                }
                if (modifiers.isEmpty()) continue;
                typeAnnotation = annotation;
            }
            return null;
        }
    }

    private class SortModifiersFix
    extends InspectionGadgetsFix {
        private SortModifiersFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("missorted.modifiers.sort.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiModifierList) && !((element = element.getParent()) instanceof PsiModifierList)) {
                return;
            }
            PsiModifierList modifierList = (PsiModifierList)element;
            String text2 = String.join((CharSequence)" ", MissortedModifiersInspection.this.getSortedModifiers(modifierList));
            PsiModifierList newModifierList = this.createNewModifierList(modifierList, text2);
            if (newModifierList != null) {
                new CommentTracker().replaceAndRestoreComments((PsiElement)modifierList, (PsiElement)newModifierList);
            }
        }

        @Nullable
        private PsiModifierList createNewModifierList(@NotNull PsiModifierList oldModifierList, @NotNull String newModifiersText) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)oldModifierList.getProject());
            if (oldModifierList.getParent() instanceof PsiRequiresStatement) {
                String text2 = "requires " + newModifiersText + " x;";
                PsiRequiresStatement statement = (PsiRequiresStatement)factory.createModuleStatementFromText(text2, (PsiElement)oldModifierList);
                return statement.getModifierList();
            }
            PsiMethod method = factory.createMethodFromText(newModifiersText + " void x() {}", (PsiElement)oldModifierList);
            return method.getModifierList();
        }
    }
}

