/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodRefCanBeReplacedWithLambdaInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodRefToLambdaVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)infos[0];
        boolean onTheFly = (Boolean)infos[1];
        if (LambdaRefactoringUtil.canConvertToLambdaWithoutSideEffects(methodReferenceExpression)) {
            return new MethodRefToLambdaFix();
        }
        if (onTheFly) {
            return new SideEffectsMethodRefToLambdaFix();
        }
        return null;
    }

    private static class SideEffectsMethodRefToLambdaFix
    extends MethodRefToLambdaFix {
        private SideEffectsMethodRefToLambdaFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            return ApplicationManager.getApplication().isUnitTestMode() ? InspectionGadgetsBundle.message("side.effects.method.ref.to.lambda.fix.family.name", super.getFamilyName()) : super.getFamilyName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void doFix(Project project, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
                if (editor != null) {
                    CommandProcessor.getInstance().executeCommand(project, () -> SideEffectsMethodRefToLambdaFix.doFixAndRemoveSideEffects(editor, methodReferenceExpression), this.getFamilyName(), null);
                }
            });
        }

        private static void doFixAndRemoveSideEffects(@NotNull Editor editor, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{methodReferenceExpression})) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)WriteAction.compute(() -> LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true));
            if (lambdaExpression != null) {
                LambdaRefactoringUtil.removeSideEffectsFromLambdaBody(editor, lambdaExpression);
            }
        }
    }

    private static class MethodRefToLambdaFix
    extends InspectionGadgetsFix {
        private MethodRefToLambdaFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("method.ref.can.be.replaced.with.lambda.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiMethodReferenceExpression) {
                this.doFix(project, (PsiMethodReferenceExpression)element);
            }
        }

        protected void doFix(Project project, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true);
        }
    }

    private static class MethodRefToLambdaVisitor
    extends BaseInspectionVisitor {
        private MethodRefToLambdaVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression methodReferenceExpression) {
            super.visitMethodReferenceExpression(methodReferenceExpression);
            if (LambdaRefactoringUtil.canConvertToLambda(methodReferenceExpression)) {
                this.registerError((PsiElement)methodReferenceExpression, methodReferenceExpression, this.isOnTheFly());
            }
        }
    }
}

