/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class VariableAssignedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final Collection<? extends PsiVariable> variables;
    private final boolean recurseIntoClasses;
    private final boolean checkUnaryExpressions;
    private boolean assigned = false;
    private PsiElement excludedElement = null;

    public VariableAssignedVisitor(@NotNull Collection<? extends PsiVariable> variables, boolean recurseIntoClasses) {
        this.variables = variables;
        this.checkUnaryExpressions = true;
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public VariableAssignedVisitor(@NotNull PsiVariable variable, boolean recurseIntoClasses) {
        this.variables = Collections.singleton(variable);
        PsiType type2 = variable.getType();
        this.checkUnaryExpressions = TypeConversionUtil.isNumericType((PsiType)type2);
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public VariableAssignedVisitor(@NotNull PsiVariable variable) {
        this(variable, true);
    }

    public void setExcludedElement(PsiElement excludedElement) {
        this.excludedElement = excludedElement;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (this.assigned || element == this.excludedElement) {
            return;
        }
        super.visitElement(element);
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        for (PsiVariable psiVariable : this.variables) {
            if (!ExpressionUtils.isReferenceTo(lhs, psiVariable)) continue;
            this.assigned = true;
            break;
        }
    }

    public void visitClass(PsiClass aClass) {
        if (!this.recurseIntoClasses || this.assigned) {
            return;
        }
        super.visitClass(aClass);
    }

    public void visitUnaryExpression(@NotNull PsiUnaryExpression prefixExpression) {
        if (this.assigned) {
            return;
        }
        super.visitUnaryExpression(prefixExpression);
        if (!this.checkUnaryExpressions) {
            return;
        }
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand2 = prefixExpression.getOperand();
        for (PsiVariable psiVariable : this.variables) {
            if (!ExpressionUtils.isReferenceTo(operand2, psiVariable)) continue;
            this.assigned = true;
            break;
        }
    }

    public boolean isAssigned() {
        return this.assigned;
    }
}

